<?php

namespace Modules\Menu\app\Models;

use Kalnoy\Nestedset\NodeTrait;
use Modules\Mwz\app\Models\Slugs;
use Illuminate\Database\Eloquent\Model;
use Modules\Menu\app\Models\MenuTranslate;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Menu extends Model
{
	use HasFactory, NodeTrait;

	protected $fillable = [
		'section',
		'type',
		'url',
		'slug_id',
		'widget',
		'tag',
		'style',
		'_lft',
		'_rgt',
		'parent_id',
		'sequence',
		'status',
	];
	protected $table = 'menus';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
		});
	}

	public function langs()
	{
		return $this->hasMany(MenuTranslate::class, 'menu_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(MenuTranslate::class, 'menu_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function slug()
	{
		return $this->hasOne(Slugs::class, 'uid', 'slug_id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function child()
	{
		return $this->hasMany(Menu::class, 'parent_id', 'id')->where('status', 1)->orderBy('_lft');
	}
}
