<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Kalnoy\Nestedset\NestedSet;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up(): void
	{
		Schema::create('menus', function (Blueprint $table) {
			$table->id();
			$table->string('section')->nullable();
			$table->integer('type')->nullable();
			$table->string('url')->nullable();
			$table->string('slug_id')->nullable();
			$table->string('widget')->nullable();
			$table->string('tag')->nullable();
			$table->string('style')->nullable();
			NestedSet::columns($table);
			$table->integer('sequence')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
		});
		Schema::create('menu_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('menu_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->string('desc')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('menu_translate');
		Schema::dropIfExists('menus');
	}
};
