<?php

namespace Modules\Menu\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = DB::raw('NOW()');
        DB::statement("ALTER TABLE menus AUTO_INCREMENT=1");

        DB::table('menus')->truncate();

        DB::table('menus')->insert([
            [
                'id' => 1,
                'section' => null,
                'type' => null,
                'url' => null,
                'slug_id' => null,
                'widget' => null,
                'tag' => null,
                'style' => null,
                '_lft' => 1,
                '_rgt' => 2,
                'parent_id' => null,
                'sequence' => 1,
                'status' => 1,
                'deleted_at' => null,
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 2,
                'section' => null,
                'type' => null,
                'url' => null,
                'slug_id' => null,
                'widget' => null,
                'tag' => null,
                'style' => null,
                '_lft' => 3,
                '_rgt' => 4,
                'parent_id' => null,
                'sequence' => 2,
                'status' => 1,
                'deleted_at' => null,
                'created_at' => $now,
                'updated_at' => $now
            ]
        ]);
    }
}
