$(document).ready(function () {
	initDatatable();
	initTree();
	($('#type').length > 0) && $('#type').change();

})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#menu-datatable").length > 0) {
		var column = [
			{ data: "DT_RowIndex", className: 'text-center' },
			{ data: "name", },
			// { data: "link", orderable: false }
		];
		($_config.setting.parent.status) && column.push({ data: "parent_id" });
		($_config.setting.widget.status) && column.push({ data: "widget" });
		($_config.setting.style.status) && column.push({ data: "style" });
		column.push(
			{ data: "sort", orderable: false, className: 'text-center' },
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		$("#menu-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: `/admin/menu/menu/${$_group_id}/datatable_ajax`,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#menu-datatable").length > 0) &&
		$("#menu-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/menu/${$_group_id}/set_status`,
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	})
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/menu/${$_group_id}/set_delete`,
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Sort Item
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSort = function (id, move) {
	event.preventDefault();
	$.ajax({
		url: `/admin/menu/menu/${$_group_id}/set_sort`,
		type: "POST",
		data: { id: id, move: move },
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();

	var frm = $("#menu_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: `/admin/menu/menu/${$_group_id}/save`,
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = [], msg = [];
			$.each($_lang, function (i, lang) {
				$.each($_config.input, function (key, ele) {
					rules[`${key}_${lang}`] = (key == "name") ? { required: ele.validate && ele.status, maxlength: 255 } : { required: ele.validate && ele.status };
					msg[`${key}_${lang}`] = { required: $(`[name="${key}_${lang}"]`).attr('placeholder') };
				});
			});
			$.each($_config.setting, function (key, ele) {
				rules[key] = { required: ele.validate && ele.status };
				msg[key] = { required: $(`[name="${key}"]`).attr('placeholder') };
			});

			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) {
			mwz_noti("success", resp.msg, window.location.replace(`/admin/menu/menu/${$_group_id}`));
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};

/**
* Function : Init Tree
* Dev : Peh
* Update Date : 26 Apr 2024
*/
window.initTree = function () {
	if ($('#tree_view').length > 0) {
		$("#tree_view").jstree({
			core: {
				check_callback: !0,
				themes: { responsive: !1 }
			},
			plugins: ["types", "dnd"]
		});
		$('#tree_view').on('move_node.jstree', function (event, data) {
			var id = $(`#${data.node.id}`).data('id');
			if (data.node.parent == '#') {
				setTreeSort(id, 0, data.position, data.old_position);
			} else {
				setTreeSort(id, $(`#${data.node.parent}`).data('id'), data.position, data.old_position);
			}
		});
	}
};
/**
* Function : sort Tree
* Dev : Peh
* Update Date : 26 Apr 2024
*/

window.setTreeSort = function (id, parent_id, position, old_position) {

	event.preventDefault();
	$.ajax({
		url: `/admin/menu/menu/${$_group_id}/tree/sort`,
		type: "POST",
		data: {
			id: id,
			parent_id: parent_id,
			position: position,
			old_position: old_position,
		},
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		success: function (resp) {
			mwz_noti("success", resp.msg);
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
}
/**
* Function : select type
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.$('#type').change(function () {
	var type = $(this).val();
	if ($('.select-type').length > 0) {
		$('.select-type').hide();
		$('.select-type').each(function () {
			if (type == $(this).data('id')) { $(this).show(); }
		})
	}
})