    <div class="card card-body">
        @if (!empty($setting['parent']['status']))
            <div class="mb-2">
                <?php $selected = $data->parent ?? null; ?>
                <x-select2.select id="parent_id" name="parent_id" :selected=$selected label="{{ __('field.parent') }}"
                    url="{{ route('admin.menu.menu.get_list', [$group_id]) }}"
                    placeholder="{{ __('field.parent_placeholder') }}" parent="group_id,id" />
            </div>
        @endif
        @if (!empty($setting['widget']['status']))
            <div class="mb-2">
                <x-select2.selection class="select2" id="widget" name="widget" label="{{ __('field.widget') }}"
                    placeholder="{{ __('field.widget_placeholder') }}">
                    @slot('option')
                        @if (!empty($config['widgets']))
                            @foreach ($config['widgets'] as $w => $name)
                                <option value="{{ $w }}" @if (!empty($data->widget) && $data->widget == $w) selected @endif>
                                    {{ $name }} </option>
                            @endforeach
                        @endif
                    @endslot
                </x-select2.selection>
            </div>
        @endif
        @if (!empty($setting['style']['status']))
            <div class="mb-2">
                <?php $styles = ['normal' => 'Normal', 'style' => 'Style']; ?>
                <x-select2.selection class="select2" id="style" name="style" label="{{ __('field.style') }}"
                    placeholder="{{ __('field.style_placeholder') }}">
                    @slot('option')
                        @foreach ($styles as $s => $style)
                            <option value="{{ $s }}" @if (!empty($data->style) && $data->style == $s) selected @endif>
                                {{ $style }} </option>
                        @endforeach
                    @endslot
                </x-select2.selection>
            </div>
        @endif
    </div>
