<?php

namespace Modules\Mwz\app\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Exceptions\HttpResponseException;
use Symfony\Component\HttpFoundation\Response;

class AdminController extends Controller
{
	public static $navbar;

	public static function setPermissions($path, $permission = 0775)
	{
		$path = str_replace(
			'storage',
			'public',
			$path
		);
		$path_arr = explode('/', $path);
		$folderPath = storage_path('app');
		foreach ($path_arr as $key => $value) {
			if ($value == 'public') {
				$folderPath = $folderPath . $value;
			} else {
				$folderPath = $folderPath . '/' . $value;
				if (file_exists($folderPath)) {
					chmod($folderPath, $permission);
				}
			}
		}
	}

	/**
	 * Function : upload image
	 * Dev : Petch
	 * Update Date : 22 Jan 2025
	 * @param Illuminate\Http\Request $request
	 * @param string $image_name
	 * @param string $path
	 * @param string $file_name
	 * @param boolean $favicon
	 * @return string image path
	 */
	public static function set_image_upload($request, $image_name, $path = "public", $file_name = "", $favicon = false)
	{
		$image_path = '';
		if ($request->hasFile($image_name)) {
			$image = $request->file($image_name);
			$mimeType = $image->getMimeType();
			$clientMimeType = $image->getClientMimeType();

			if ($clientMimeType !== $mimeType) {
				self::throwInvalidFileResponse($image_name);
			}

			if (!Str::startsWith($mimeType, 'image/')) {
				self::throwInvalidFileResponse($image_name);
			}

			$validImageTypes = ['image/apng', 'image/avif', 'image/gif', 'image/jpeg', 'image/png', 'image/webp', 'image/svg+xml'];
			$validFaviconTypes = ['image/x-icon', 'image/vnd.microsoft.icon', 'image/png', 'image/svg+xml'];

			$new_filename = $file_name . time() . "." . $image->extension();
			if ($favicon) {
				if (!in_array($mimeType, $validFaviconTypes, true)) {
					self::throwInvalidFileResponse($image_name, true);
				}

				$image_path = str_replace('public', 'storage', "/{$path}/{$new_filename}");
				Image::make($image->path())->resize(100, 100, function ($con) {
					$con->aspectRatio();
				})->save(public_path($image_path));
			} else {
				if (!in_array($mimeType, $validImageTypes, true)) {
					self::throwInvalidFileResponse($image_name);
				}

				$path = $image->storeAs($path, $new_filename);
				$image_path = Storage::url($path);
			}
			self::setPermissions($image_path);
			if (!empty($request->get($image_name . '_old'))) {
				$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
				Storage::delete($old_path);
			}

			return !empty($image_path) ? $image_path : null;
		} elseif (!empty($request->get($image_name . '_del')) && $request->get($image_name . '_del') == 1) {
			$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
			Storage::delete($old_path);

			return null;
		} else {
			return !empty($request->get($image_name . '_old')) ? $request->get($image_name . '_old') : null;
		}

		return !empty($image_path) ? $image_path : null;
	}


	// public static function set_image_upload($request, $image_name, $path = "public", $file_name = "", $favicon = false)
	// {
	// 	$image_path = '';
	// 	if ($request->hasFile($image_name)) {
	// 		$image = $request->file($image_name);
	// 		if ($image->getClientMimeType() !== $image->getMimeType() and empty($favicon))
	// 			return null;

	// 		$new_filename = $file_name . time() . "." . $image->extension();
	// 		if ($favicon and $image->getClientMimeType() !== 'image/x-icon') {
	// 			$image_path = str_replace('public', 'storage', "/{$path}/{$new_filename}");
	// 			Image::make($image->path())->resize(100, 100, function ($con) {
	// 				$con->aspectRatio();
	// 			})->save(public_path($image_path));
	// 		} else {
	// 			$path = $image->storeAs($path, $new_filename);
	// 			$image_path = Storage::url($path);
	// 		}
	// 		self::setPermissions($image_path);
	// 		if (!empty($request->get($image_name . '_old'))) {
	// 			$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
	// 			Storage::delete($old_path);
	// 		}

	// 		return !empty($image_path) ? $image_path : null;
	// 	} elseif (!empty($request->get($image_name . '_del')) && $request->get($image_name . '_del') == 1) {
	// 		$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
	// 		Storage::delete($old_path);

	// 		return null;
	// 	} else {
	// 		return !empty($request->get($image_name . '_old')) ? $request->get($image_name . '_old') : null;
	// 	}

	// 	return !empty($image_path) ? $image_path : null;
	// }

	private static function resizeImageIfNeeded($image_path, $max_width = 100, $max_height = 100)
	{
		$img = Image::make($image_path);
		
		// ตรวจสอบขนาดรูปก่อน resize
		if ($img->width() > $max_width || $img->height() > $max_height) {
			$img->resize($max_width, $max_height, function ($con) {
				$con->aspectRatio();
			});
		}
		
		return $img;
	}


	/**
	 * Function : upload image
	 * Dev : Wan
	 * Update Date : 10 Apr 2025
	 * @param Illuminate\Http\Request $request
	 * @param string $image_name
	 * @param string $path
	 * @param string $file_name
	 * @param boolean $favicon
	 * @return string image path
	 */
	public static function set_image_upload_multiple($request, $image_name, $path = "public", $file_name = "", $favicon = false)
	{
		$image_path = '';

		if ($request->hasFile($image_name)) {
			$image = $request->file($image_name);

			if ($image->getClientMimeType() !== $image->getMimeType()) {
				self::throwInvalidFileResponse($image_name);
			}

			$new_filename = $file_name . time() . "." . $image->extension();
			if ($favicon) {
				// Check if it's a valid image type before processing with GD
				$validImageTypes = ['image/apng', 'image/avif', 'image/gif', 'image/jpeg', 'image/png', 'image/webp', 'image/x-icon', 'image/vnd.microsoft.icon', 'image/svg+xml'];
				if (!in_array($image->getMimeType(), $validImageTypes)) {
					self::throwInvalidFileResponse($image_name, true); // Return null for invalid image types
				}
				
				$image_path = str_replace('public', 'storage', "/{$path}/{$new_filename}");
				Image::make($image->path())->resize(100, 100, function ($con) {
					$con->aspectRatio();
				})->save(public_path($image_path));
			} else {
				$path = $image->storeAs($path, $new_filename);
				$image_path = Storage::url($path);
			}
			self::setPermissions($image_path);
			if (!empty($request->get($image_name . '_old'))) {
				$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
				Storage::delete($old_path);
			}

			return !empty($image_path) ? $image_path : null;
		} elseif (!empty($request->get($image_name . '_del')) && $request->get($image_name . '_del') == 1) {
			$old_path = str_replace('storage', 'public', $request->get($image_name . '_old'));
			Storage::delete($old_path);

			return null;
		} else {
			return !empty($request->get($image_name . '_old')) ? $request->get($image_name . '_old') : null;
		}

		return !empty($image_path) ? $image_path : null;
	}

	protected static function throwInvalidFileResponse(string $field, bool $favicon = false): void
	{
		$message = $favicon ? __('noti.mime_favicon') : __('noti.mime_image');

		throw new HttpResponseException(
			self::response([
				'msg' => $message,
				'error' => [
					$field => [$message],
				],
			], Response::HTTP_UNPROCESSABLE_ENTITY)
		);
	}

	/**
	 * Function : filter date when query
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 * @param mixed $req is Model
	 * @param integer $period is case filter
	 * @param string $fill is column name
	 * @param string $range is date range
	 * @return mixed $req is Model end process
	 */
	public static function mwz_filter($req, $period, $fill = 'created_at', $range = null)
	{
		switch ($period) {
			case 1: // วันนี้
				$req = $req->whereBetween($fill, [now()->startOfDay(), now()->endOfDay()]);
				break;
			case 2: // เมื่อวาน 
				$req = $req->whereBetween($fill, [now()->subDay()->startOfDay(), now()->subDays()->endOfDay()]);
				break;
			case 3: // 7 วันล่าสุด
				$req = $req->whereBetween($fill, [now()->subWeek(), now()]);
				break;
			case 4: // 30 วันล่าสุด
				$req = $req->whereBetween($fill, [now()->subDays(30), now()]);
				break;
			case 5: // เดือนนี้
				$req = $req->whereBetween($fill, [now()->startOfMonth(), now()->endOfMonth()]);
				break;
			case 6: // เดือนล่าสุด
				$req = $req->whereBetween($fill, [now()->subMonth()->startOfMonth(), now()->subMonth()->endOfMonth()]);
				break;
			case 7: // กำหนดเอง
				if (!empty($range)) {
					if (str_contains($range, 'to')) {
						list($start, $end) = explode(' to ', $range);
						$req = $req->whereBetween($fill, [Carbon::parse($start)->startOfDay(), Carbon::parse($end)->endOfDay()]);
					} else {
						$req = $req->where($fill, '=', Carbon::parse($range)->startOfDay());
					}
				}
				break;
		}
		return $req;
	}

	/**
	 * Function : for view file type
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 * @param string $type is file type
	 * @param string $src is path
	 * @return string html tag
	 */
	public static function view_file($type, $src = null)
	{
		switch ($type) {
			case 'file':
				return "<i class=\"fe-file-text fs-1\"></i>";
				break;
			case 'video':
				return "<i class=\"fe-video fs-1\"></i>";
				break;
			case 'youtube':
				return "<i class=\"fe-youtube fs-1\"></i>";
				break;
			default:
				return "<img class=\"img-table\" src=\"{$src}\" onerror=\"this.remove()\">";
				break;
		}
	}

	/**
	 * Function : btn user status
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 * @param integer $id is user id
	 * @param string $func is function name
	 * @param integer $status is status for check
	 * @return string html tag button
	 */
	public static function user_status($id, $func = 'setUpdateStatus', $status = 0)
	{
		$data = ['class' => 'text-white btn-warning', 'icon' => 'fe-x'];

		if ($status == 1)
			$data = ['class' => 'btn-success', 'icon' => 'fe-check'];

		return "<button type=\"button\" onclick=\"{$func}({$id});\" class=\"btn btn-mwz waves-effect {$data['class']}\"><i class=\"{$data['icon']}\"></i></button>";
	}

	/**
	 * Function : btn user route
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 * @param string $route is route name
	 * @param integer $id is user id
	 * @return string html tag a
	 */
	public static function user_route($route, $id, $icon = 'fe-edit-1')
	{
		return "<a href=\"" . route($route, $id) . "\" class=\"btn btn-mwz waves-effect btn-white\"><i class=\"" . $icon . "\"></i></a>";
	}

	/**
	 * Function : btn user delete
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 * @param integer $id is user id
	 * @param string $func is function name
	 * @return string html tag button
	 */
	public static function user_delete($id, $func = 'setDelete', $class = '')
	{
		return "<button type=\"button\" onclick=\"mwz_delete({$func},{$id})\" class=\"btn btn-mwz waves-effect btn-danger {$class}\"><i class=\"fe-trash\"></i></button>";
	}

	/**
	 * Function : btn default
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function btn_default($route, $id, $func, $status,$disabled = '', $icon = 'mdi mdi-pin', $active = 'btn-outline-warning')
	{
		if (mwz_roles($route)) {
			if ($status == 1) {
				return "<button type=\"button\" onclick=\"{$func}({$id});\" class=\"btn btn-mwz waves-effect {$active} {$disabled}\"><i class=\"{$icon}\"></i></button>";
			}

			return "<button type=\"button\" onclick=\"{$func}({$id});\" class=\"btn btn-mwz waves-effect btn-white {$disabled}\"><i class=\"{$icon}\"></i></button>";
		}
	}
	public static function parent($query = null, $row = [])
	{
		if (!empty($query)) {
			if (!empty($query->local->name)) {
				array_unshift($row, $query->local->name);
			} elseif (!empty($query->name)) {
				array_unshift($row, $query->name);
			}
			$row = self::parent($query->parent ?? null, $row);
		}
		return $row;
	}
	/**
	 * Function : btn status
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function btn_status($route_name, $id, $func = 'setUpdateStatus', $status = 0)
	{
		if (mwz_roles($route_name)) {
			if ($status == 1) {
				return "<button type=\"button\" onclick=\"{$func}({$id});\" class=\"btn btn-mwz waves-effect btn-success\" title=\"" . __("action.status") . "\"><i class=\"fe-check\"></i></button>";
			}
			return "<button type=\"button\" onclick=\"{$func}({$id});\" class=\" btn btn-mwz waves-effect btn-warning\" title=\"" . __("action.status") . "\"><i class=\"fe-x\"></i></button>";
		}
	}

	/**
	 * Function : btn custom
	 * Dev : Petch
	 * Update Date : 26 Apr 2024
	 */
	public static function btn_custom($route_name, $func = 'default', $parems = [], $class = 'btn-white', $txt = '', $icon = 'fe-alert-circle', $disabled = false)
	{
		if (mwz_roles($route_name)) {
			$p = implode(', ', $parems);

			return "<button type='button' onclick='{$func}({$p});' class='btn btn-mwz waves-effect {$class}' title='{$txt}'" . ($disabled ? " disabled" : "") . "><i class='{$icon}'></i></button>";
		}
	}

	/**
	 * Function : badge
	 * Dev : Petch
	 * Update Date : 19 Feb 2025
	 */
	public static function badge($row)
	{
		$txt = '<div class="d-flex flex-wrap">';

		if (!empty($row)) {
			foreach ($row as $item)
				$txt .= '<span class="badge badge-mwz">' . ($item->local->name ?? '') . '</span>';
		}

		$txt .= '</div>';

		return $txt;
	}
	public static function listColumn($row = [])
	{
		$txt = "<div class=\"w-100\">";
		if (!empty($row)) {
			foreach ($row as $key => $value) {
				$txt .= "<div class=\"d-flex justify-content-between\">
                            <div class=\"fw-bold text-muted\">" . __("field.{$key}") . " :</div>
                            <div class=\"text-end\">" . ($value ?? '') . "</div>
                        </div>";
			}
		}
		$txt .= '</div>';

		return $txt;
	}

	/**
	 * Function : btn route
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public static function btn_route($route, $id, $class = 'btn-white', $icon = 'fe-edit-1', $target = '_self', $title = null)
	{
		if (mwz_roles($route)) {
			return '<a href="' . route($route, $id) . "\" class=\"btn btn-mwz waves-effect {$class}\"  title=\"" . ($title ?? __("action.edit")) . "\"  target=\"{$target}\" ><i class=\"{$icon}\"></i> " . ($title ?? "") . "</a>";
		} else {
			$route = str_replace('.edit', '.view', $route);
			return '<a href="' . route($route, $id) . '" class="btn btn-mwz waves-effect waves-light btn-white"  title="' . __("action.view") . '"><i class="fe-eye"></i></a>';
		}
	}

	public static function roles_route($roles, $url, $class = 'btn-white', $icon = 'fe-edit-1', $target = '_self')
	{
		if (mwz_roles($roles)) {
			return "<a href=\"{$url}\" class=\"btn btn-mwz waves-effect {$class}\"  title=\"" . __("action.view") . "\"  target=\"{$target}\" ><i class=\"{$icon}\"></i></a>";
		}
	}

	/**
	 * Function : btn delete
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function btn_delete($route, $id, $func = 'setDelete', $class = '')
	{
		if (mwz_roles($route)) {
			return "<button type=\"button\" onclick=\"mwz_delete({$func},{$id})\" class=\"btn btn-mwz waves-effect btn-danger {$class}\" title=\"" . __("action.delete") . '"><i class="fe-trash-2"></i></button>';
		}
	}

	/**
	 * Function : btn sort
	 * Dev : Petch
	 * Update Date : 19 Feb 2025
	 */
	public static function btn_sort($route, $id, $func = 'setUpdateSort', $sort = 0, $disabled = false)
	{
		if (mwz_roles($route)) {
			$txt = "<div id='sort_{$sort}_{$id}' class='text-center'><div class='button-list'>";
			$txt .= "<button type='button' onclick='{$func}({$id},\"up\");' class='btn btn-mwz waves-effect btn-white'" . ($disabled ? ' disabled ' : '') . "><i class='mdi mdi-arrow-up-thick'></i></button>";
			$txt .= "<button type='button' onclick='{$func}({$id},\"down\");' class='btn btn-mwz waves-effect btn-white'" . ($disabled ? ' disabled ' : '') . "><i class='mdi mdi-arrow-down-thick'></i></button>";
			$txt .= "</div></div>";

			return $txt;
		}
	}

	/**
	 * Function : btn route use href
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function route_button($route, $icon = 'fe-external-link', $target = '_self')
	{
		return "<a href=\"{$route}\" class=\"btn btn-mwz btn-white waves-effect\" target=\"{$target}\"><i class=\"{$icon}\"></i></a>";
	}

	/**
	 * Function : form check box
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function form_check($name = 'select', $id = 0)
	{
		return ("<div class=\"form-check\">
                    <input class=\"form-check-input table-select\" type=\"checkbox\" name=\"{$name}\" value=\"{$id}\" id=\"item-{$id}\" onclick=\"selectTable();\">
                    <label class=\"form-check-label\" for=\"item-{$id}\"></label>
                </div>");
	}

	public static function progress($min = 0, $max = 100, $value = 0, $class = null, $height = 10)
	{
		$cal = ($value - $min) / ($max - $min) * 100;
		return "<div class=\"progress mt-1\" style=\"height: {$height}px;\">
                    <div class=\"progress-bar {$class}\" role=\"progressbar\" style=\"width: {$cal}%;\" aria-valuenow=\"{$value}\" aria-valuemin=\"{$min}\" aria-valuemax=\"{$max}\"></div>
                </div>";
	}

	/**
	 * Function : homepage
	 * Desc: เช็คสิทธิ์ที่สามารถเข้าถึงหน้าหลักได้
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public function homepage()
	{
		$menus = mwz_side_menu();
		if (!empty($menus)) {
			foreach ($menus as $menu) {
				$route = self::check_route($menu);
				if (!empty($route)) {
					return redirect()->route($route);
				}
			}
		}
		if (env('APP_DEBUG')) {
			return redirect()->route('admin.mwz.admin_menu.index');
		}
		abort(403);
	}

	/**
	 * Function : check route
	 * Desc: เช็ค route ที่สามารถเข้าถึงได้
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function check_route($menu)
	{
		if (!empty($menu['side'])) {
			foreach ($menu['side'] as $side)
				return self::check_route($side);
		} else if (!empty($menu['route'])) {
			return $menu['route'];
		}
	}

	/**
	 * Function : set metadata
	 * Desc: ตั้งค่า metadata สำหรับการแสดงผล
	 * Dev : Petch
	 * Update Date : 25 Jan 2025
	 */
	public static function set_metadata($module, $method, $level = 1)
	{
		$meta = [];
		foreach (array_keys(languages()) as $lang)
			$meta[$lang] = ['module' => $module, 'method' => $method, 'level' => $level];

		return $meta;
	}

	/**
	 * Function : create uuid
	 * Desc: สร้าง uuid
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public  static function str_uuid(): string
	{
		return (string) Str::uuid();
	}

	/**
	 * Function : certe response
	 * Desc: สร้าง response สำหรับการตอบกลับ
	 * Dev : Poom
	 * Update Date : 26 Apr 2024
	 */
	public static function response($resp = [], $code = 200, $callback = null)
	{
		$resp['code'] = $code;
		return response()->json(
			$resp,
			$code,
			['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'],
			JSON_UNESCAPED_UNICODE
		)->withCallback($callback);
	}
	/**
	 * Function : delete image file
	 * dev : Petch
	 * Update Date : 18 Apr 2024
	 * @param string $path
	 * @return void
	 */
	public static function delete_image($path)
	{
		if (!empty($path)) {
			$path = str_replace('storage', 'public', $path);
			if (Storage::exists($path))
				Storage::delete($path);
		}
	}
	/**
	 * Function : Youtube Filter Embed
	 * dev : Poom
	 * Update Date : 9 May 2024
	 * @param string $base
	 * @return void
	 */
	public static function embed($base = null): string
	{
		$embed = '';
		if (!empty($base)) {
			$url = parse_url($base);
			if ($url === false || empty($url['host'])) {
				return $base; // or handle the error as needed
			}
			$host = $url['host'];
			$path = $url['path'] ?? '';
			$query = $url['query'] ?? '';

			// Extract the video ID
			if (strpos($host, 'youtube.com') !== false && strpos($path, 'watch') !== false) {
				parse_str($query, $queryParams);
				$embed = $queryParams['v'] ?? null;
			} elseif (strpos($host, 'youtu.be') !== false) {
				$embed = substr($path, 1);
			} elseif (strpos($host, 'www.youtube.com') !== false && strpos($path, 'embed') !== false) {
				$p = explode('/', $path);
				$embed = substr(end($p), 0);
			}
			if (!empty($embed)) {
				return $embed;
			}
		}
		return $base;
	}

	public static function encode($data, $prefix = '', $suffix = '')
	{
		return base64_encode($prefix . $data . $suffix);
	}

	public static function decode($data, $prefix = '', $suffix = '')
	{
		$decode = base64_decode($data);
		// Remove the prefix and suffix
		if ($prefix && strpos($decode, $prefix) === 0) {
			$decode = substr($decode, strlen($prefix));
		}
		if ($suffix && substr($decode, -strlen($suffix)) === $suffix) {
			$decode = substr($decode, 0, -strlen($suffix));
		}
		return $decode;
	}
}
