<?php

namespace Modules\Mwz\app\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Mwz\app\Models\Cities;

class MwzController extends AdminController
{

    public function address(Request $request)
    {
        $data = [];
        $o_data = new Cities();
        $o_data = $o_data->where('zipcode', $request->get('zipcode'));
        $list = $o_data->get();
        if (!empty($list)) {
            foreach ($list as $item) {
                $data['city'][$item->id] = ['text' => $item->local->name ?? null,  'province_id' => $item->province_id, 'district_id' => $item->district_id];
                $data['district'][$item->district_id] = ['text' => $item->district->local->name ?? null, 'province_id' => $item->district->province_id];
                $data['province'][$item->province_id] = ['text' => $item->province->local->name ?? null,];
            }

            return response()->json($data, 200);
        }
        return response(__('noti.no-data'), 404);
    }
    public static function call($zipcode = null)
    {
        if (empty($zipcode) || strlen($zipcode) != 5) {
            return null;
        }
        $data = [];
        $req = Cities::where('zipcode', $zipcode)->get();
        if (!empty($req)) {
            foreach ($req as $item) {
                $data['city'][$item->id] = ['text' => $item->local->name ?? null,  'province_id' => $item->province_id, 'district_id' => $item->district_id];
                $data['district'][$item->district_id] = ['text' => $item->district->local->name ?? null, 'province_id' => $item->district->province_id];
                $data['province'][$item->province_id] = ['text' => $item->province->local->name ?? null,];
            }
        }
        return $data;
    }
}
