<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Mwz\Database\factories\DistrictsFactory;

class Districts extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'geo_id', 'province_id', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "mwz_district";
    protected $primaryKey = "id";

    protected static function newFactory(): DistrictsFactory
    {
        return DistrictsFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(DistrictTranslate::class, 'district_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(DistrictTranslate::class, 'district_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
    public function geo()
    {
        return $this->hasOne(Geographies::class, 'id', 'geo_id');
    }
    public function province()
    {
        return $this->hasOne(Provinces::class, 'id', 'province_id');
    }
}
