<?php

namespace Modules\Mwz\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Permissions extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'name',
		'group',
		'type',
		'module',
		'page',
		'action',
		'route_name',
		'role',
	];
	protected $table = 'mwz_permissions';
	protected $primaryKey = 'id';

	public function roles()
	{
		return $this->hasMany(Permissions::class, 'role', 'role');
	}

	public function menu()
	{
		return $this->hasOne(AdminMenus::class, 'permission_id', 'id');
	}
}
