<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Kalnoy\Nestedset\NestedSet;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up(): void
	{
		Schema::create('mwz_menus', function (Blueprint $table) {
			$table->id();
			$table->string('icon')->nullable();
			$table->string('name')->nullable();
			$table->integer('permission_id')->nullable();
			NestedSet::columns($table);
			$table->integer('sequence')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
		});

		Schema::create('mwz_slugs', function (Blueprint $table) {
			$table->id();
			$table->string('uid')->nullable();
			$table->integer('level')->nullable();
			$table->integer('type')->nullable();
			$table->string('module')->nullable();
			$table->string('method')->nullable();
			$table->integer('data_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('slug')->nullable();
			$table->string('param')->nullable();
			$table->string('meta_auther')->nullable();
			$table->string('meta_title')->nullable();
			$table->string('meta_keywords')->nullable();
			$table->text('meta_description')->nullable();
			$table->text('meta_image')->nullable();
			$table->string('meta_robots')->nullable();
			$table->integer('status')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		Schema::create('mwz_notifications', function (Blueprint $table) {
			$table->id();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->string('to_emal')->nullable();
			$table->string('cc_email')->nullable();
			$table->string('subjectmail')->nullable();
			$table->mediumText('paintext')->nullable();
			$table->mediumText('body')->nullable();
			$table->boolean('status')->default(0);
			$table->integer('sequence')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
		Schema::create('mwz_permissions', function (Blueprint $table) {
			$table->id();
			$table->string('name')->nullable();
			$table->string('group')->nullable();
			$table->integer('type')->nullable();
			$table->string('module')->nullable();
			$table->string('page')->nullable();
			$table->string('action')->nullable();
			$table->string('route_name')->nullable();
			$table->string('role')->nullable();
			$table->timestampsTz();
		});
		Schema::create('mwz_geo', function (Blueprint $table) {
			$table->id();
			$table->softDeletes();
			$table->timestampsTz();
		});
		Schema::create('mwz_geo_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('geo_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->text('desc')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});
		Schema::create('mwz_provinces', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('geo_id')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});
		Schema::create('mwz_provinces_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('province_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});
		Schema::create('mwz_district', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('geo_id')->nullable();
			$table->unsignedBigInteger('province_id')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});
		Schema::create('mwz_district_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('district_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
			$table->foreign('district_id')->references('id')->on('mwz_district');
		});
		Schema::create('mwz_city', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('geo_id')->nullable();
			$table->unsignedBigInteger('province_id')->nullable();
			$table->unsignedBigInteger('district_id')->nullable();
			$table->string('zipcode', 5)->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});

		Schema::create('mwz_city_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('city_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->softDeletes();
			$table->timestampsTz();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('mwz_menus');
		Schema::dropIfExists('mwz_slugs');
		Schema::dropIfExists('mwz_notifications');
		Schema::dropIfExists('mwz_permissions');
		Schema::dropIfExists('mwz_city_translate');
		Schema::dropIfExists('mwz_city');
		Schema::dropIfExists('mwz_district_translate');
		Schema::dropIfExists('mwz_district');
		Schema::dropIfExists('mwz_provinces_translate');
		Schema::dropIfExists('mwz_provinces');
		Schema::dropIfExists('mwz_geo_translate');
		Schema::dropIfExists('mwz_geo');
	}
};
