<?php

namespace Modules\Mwz\database\seeders;

use Illuminate\Database\Seeder;
use Modules\Mwz\app\Models\Slugs;

class MwzSlugSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		$slug = [
			['uid' => 'index-index-1', 'level' => 1, 'type' => 1, 'module' => 'index', 'method' => 'index', 'data_id' => 1, 'lang' => null, 'slug' => 'index', 'status' => 1],
			['uid' => 'about-about-1', 'level' => 1, 'type' => 1, 'module' => 'about', 'method' => 'about', 'data_id' => 1, 'lang' => null, 'slug' => 'about', 'status' => 1],
			['uid' => 'e_journal-e_journal-1', 'level' => 1, 'type' => 1, 'module' => 'e_journal', 'method' => 'e_journal', 'data_id' => 1, 'lang' => null, 'slug' => 'e_journal', 'status' => 1],
			['uid' => 'conference-conference-1', 'level' => 1, 'type' => 1, 'module' => 'conference', 'method' => 'conference', 'data_id' => 1, 'lang' => null, 'slug' => 'conference', 'status' => 1],
			['uid' => 'activities-activities-1', 'level' => 1, 'type' => 1, 'module' => 'activities', 'method' => 'activities', 'data_id' => 1, 'lang' => null, 'slug' => 'activities', 'status' => 1],
			['uid' => 'news-news-1', 'level' => 1, 'type' => 1, 'module' => 'news', 'method' => 'news', 'data_id' => 1, 'lang' => null, 'slug' => 'news', 'status' => 1],
			['uid' => 'contact-contact-1', 'level' => 1, 'type' => 1, 'module' => 'contact', 'method' => 'contact', 'data_id' => 1, 'lang' => null, 'slug' => 'contact', 'status' => 1],
			['uid' => 'policy-policy-1', 'level' => 1, 'type' => 1, 'module' => 'policy', 'method' => 'policy', 'data_id' => 1, 'lang' => null, 'slug' => 'policy', 'status' => 1],
			['uid' => 'policy-term-1', 'level' => 1, 'type' => 1, 'module' => 'policy', 'method' => 'term', 'data_id' => 1, 'lang' => null, 'slug' => 'term-condition', 'status' => 1],
			['uid' => 'search-search-1', 'level' => 1, 'type' => 1, 'module' => 'search', 'method' => 'search', 'data_id' => 1, 'lang' => null, 'slug' => 'search', 'status' => 1],
		];

		foreach ($slug as $s) {
			foreach (array_keys(languages()) as $lang) {
				$s['lang'] = $lang;

				Slugs::updateOrCreate(['uid' => $s['uid'], 'lang' => $lang], $s);
			}
		}
	}
}
