window.$_LANG = {
    action: {
        add: 'Add',
        filter: 'Filter',
        manage: 'Manage',
        import: 'IMPORT',
        export: 'EXPORT',
        no_data: 'No data found',
        zeroRecords: "No matching records found",
        loading: 'Loading data',
        search: 'Search...',
    },
    label: {
        all: 'All',
    },
    ajax: {
        error: 'An error occurred, please try again',
    },
    datatable: {
        lengthMenu: "_MENU_ items",
        zeroRecords: "Sorry - no records found",
        decimal: "",
        emptyTable: "No data available",
        info: "_START_-_END_ of _TOTAL_ items",
        infoEmpty: "No items found",
        infoFiltered: "(filtered from _MAX_ total items)",
        infoPostFix: "",
        thousands: ",",
        loadingRecords: "Loading...",
        processing: "Processing...",
        search: "",
        searchPlaceholder: "Search...",
        paginate: {
            first: "First",
            last: "Last",
            next: "Next",
            previous: "Previous",
        },
        aria: {
            sortAscending: ": activate to sort column ascending",
            sortDescending: ": activate to sort column descending",
        },
    },
    delete: {
        title: "Delete",
        msg: "Confirm Deletion?",
        confirm: "Submit",
        cancel: "Cancel",
    },
    validate: {
        messages: {
            name_th: {
                required: "Please enter the name in Thai",
                maxlength: "Please enter no more than {0} characters for the Thai title",
            },
            name_en: {
                required: "Please enter the name in English",
                maxlength: "Please enter no more than {0} characters for the English title",
            },
            rank_th: {
                required: "Please enter the position in Thai",
                maxlength: "Please enter no more than {0} characters for the Thai position",
            },
            rank_en: {
                required: "Please enter the position in English",
                maxlength: "Please enter no more than {0} characters for the English position",
            },
            desc_th: {
                required: "Please enter the description in Thai",
                maxlength: "Please enter no more than {0} characters for the Thai description",
            },
            desc_en: {
                required: "Please enter the description in English",
                maxlength: "Please enter no more than {0} characters for the English description",
            },
            detail_th: {
                required: "Please enter the details in Thai",
            },
            detail_en: {
                required: "Please enter the details in English",
            },
            brand_id: {
                required: "Please select a brand",
            },
            menu_id: {
                required: "Please select a menu",
            },
            amount: {
                required: "Please enter the discount amount",
            },
            start: {
                required: "Please enter the start date",
            },
            expire: {
                required: "Please enter the end date",
            },
            password: {
                required: "Please enter the password",
                minlength: "Password must be at least {0} characters long",
                maxlength: "Password must be no more than {0} characters long",
                regex: "Password must contain both letters and numbers",
            },
            re_password: {
                required: "Please confirm the password",
                minlength: "Password must be at least {0} characters long",
                maxlength: "Password must be no more than {0} characters long",
                regex: "Password must contain both letters and numbers",
                equalTo: "Passwords do not match",
            },
            url: {
                required: "Please enter the link",
                regex: "Please enter a link that starts with http:// or https://",
            },
        },
        error: "Invalid data",
    },
    jquery_validate: {
        required: "This field is required",
        remote: "Please fix this field",
        email: "Please enter a valid email address with @ symbol",
        url: "Please enter a valid URL",
        date: "Please enter a valid date",
        dateISO: "Please enter a valid date (ISO)",
        number: "Please enter a valid number",
        digits: "Please enter only digits",
        creditcard: "Please enter a valid credit card number",
        equalTo: "Please enter the same value again",
        accept: "Please enter a value with a valid extension",
        maxlength: function(param) { return "Please enter no more than " + param + " characters"; },
        minlength: function(param) { return "Please enter at least " + param + " characters"; },
        rangelength: function(param) { return "Please enter a value between " + param[0] + " and " + param[1] + " characters long"; },
        range: function(param) { return "Please enter a value between " + param[0] + " and " + param[1]; },
        max: function(param) { return "Please enter a value less than or equal to " + param; },
        min: function(param) { return "Please enter a value greater than or equal to " + param; },
    },
    noti: {
        success: 'Changes saved successfully',
        error: 'An error occurred, please try again',
        warning: 'Warning',
        info: 'Information',
        delete_success: 'Item deleted successfully',
        save_success: 'Data saved successfully',
        update_success: 'Data updated successfully',
        upload_success: 'Upload successful',
        upload_error: 'Upload error occurred',
        file_too_large: 'File size is too large',
        invalid_file_type: 'Invalid file type',
        network_error: 'Network connection error occurred',
        server_error: 'Server error occurred',
        validation_error: 'Please check the entered data',
        email_required: 'Please enter an email',
        email_invalid: 'Invalid email format',
        email_missing_at: 'Email must contain @',
        email_validation_error: 'Please check the email before submitting the form',
    }
};

// Apply jQuery validation messages when document is ready
document.addEventListener('DOMContentLoaded', function() {
    if (typeof $.validator !== 'undefined' && window.$_LANG && window.$_LANG.jquery_validate) {
        // Override jQuery validation messages with language-specific ones
        $.extend($.validator.messages, window.$_LANG.jquery_validate);
    }
});
