$(document).ready(function () {
	init_nav_tab();
	init_datepicker();
	initTexteditor();
	init_card();
});

window.regex = function () {
	$.validator.addMethod("regex", function (value, element) {
		return this.optional(element) || /^.*(?=.{3,})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-7])(?=.*[\d\x]).*$/.test(value);
	}, "รหัสผ่านไม่ถูกต้อง");
}
/**
* Function : Validation
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwz_validate = function (ele, rules, msg) {
	$(ele).validate({
		ignore: "",
		rules: rules,
		messages: msg,
		errorPlacement: function (err, ele) {
			err.addClass("invalid-feedback");
			if (ele.parent().hasClass('input-group')) { err.insertAfter(ele.parent()) }
			else {
				switch (ele.prop("type")) {
					case "checkbox":
						err.insertAfter(ele.parent());
						break;
					case "textarea":
						if (ele.hasClass('texteditor')) err.insertAfter(ele.next())
						else err.insertAfter(ele)
						break;
					case "select-one":
					case "select-multiple":
						err.insertAfter(ele.next())
						break;
					default:
						if (ele.hasClass('color-picker')) err.insertAfter(ele.parent())
						else err.insertAfter(ele);
						break;
				}
			}
		},
		invalidHandler: function (form, ele) {
			var errors = ele.numberOfInvalids();
			if (errors) {
				var valid = ele.errorList[0].element;
				var lang = $(valid).data('lang');
				var pane = $(valid).closest("div.tab-pane");
				var active = $(pane).attr('id');
				(lang) && $('[name="mwz-lang"]').val(lang).change();
				(active) && $(`a[href="#${active}"]`).tab("show");
			}
		},
		errorElement: "div",
		errorClass: "invalid-feedback",
		highlight: function (ele, errorClass, validClass) {
			$(ele).addClass("is-invalid").removeClass("is-valid");
		},
		unhighlight: function (ele, errorClass, validClass) {
			$(ele).addClass("is-valid").removeClass("is-invalid");
		},
	});
};
/**
* Function : check validation
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.frm_valid = function (ele) {
	if ($(ele).valid()) {
		return true;
	} else {
		mwz_noti("error", $_LANG.validate.error || $_LANG.noti.validation_error);
		return false;
	}
}
/**
* Function : Notification
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwz_noti = function (title, msg, callback = null) {
	var timeout = 2000, type = 'info';
	switch (title) {
		case 'error':
			type = 'error';
			break;
		case 'warning':
			type = 'warning';
			break;
		case 'success':
			type = 'success';
			break;
		default:
			type = 'info';
			break;
	}
	toastr.options.timeOut = timeout;
	toastr[type](msg);
	(callback !== null) && setTimeout(() => { callback() }, timeout);
}
/**
* Function : Notification Sweetalert Delete
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwz_delete = function (callback, id) {
	Swal.fire({
		icon: "question",
		title: $_LANG.delete.title,
		text: $_LANG.delete.msg,
		showCancelButton: !0,
		confirmButtonText: $_LANG.delete.confirm,
		cancelButtonText: $_LANG.delete.cancel,
		reverseButtons: true
	}).then((result) => {
		(result.isConfirmed) && callback(id);
	})
}


/**
* Function : Notification Sweetalert Send Email
* Dev : Wan
* Update Date : 26 Apr 2024
*/
window.mwz_send_email = function (callback, id) {
	Swal.fire({
		icon: "question",
		title: $_LANG.send_email.title,
		text: $_LANG.send_email.msg,
		showCancelButton: !0,
		confirmButtonText: $_LANG.send_email.confirm,
		cancelButtonText: $_LANG.send_email.cancel,
		reverseButtons: true
	}).then((result) => {
		(result.isConfirmed) && callback(id);
	})
}

/**
* Function : Generate Matadata
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwzGenerateMatadata = function (force = 1, field = "name", title = "name", keywords = "name", desc = "desc") {
	$.each($_lang, function (index, lang) {
		if (force) {
			($(`#${field}_${lang}`).length > 0) && $(`#meta_${lang}_slug`).val(slug($(`#${field}_${lang}`).val()));
			($(`#${title}_${lang}`).length > 0) && $(`#meta_${lang}_title`).val($(`#${title}_${lang}`).val());
			($(`#${keywords}_${lang}`).length > 0) && $(`#meta_${lang}_keywords`).val($(`#${keywords}_${lang}`).val());
			($(`#${title}_${lang}`).length > 0) && $(`#meta_${lang}_description`).val(`${$(`#${title}_${lang}`).val()} ${$(`#${desc}_${lang}`).val() ?? ""}`);
		} else {
			($(`#meta_${lang}_slug`).val() == "" && $(`#${field}_${lang}`).length > 0) && $(`#meta_${lang}_slug`).val(slug($(`#${field}_${lang}`).val()));
			($(`#meta_${lang}_title`).val() == "" && $(`#${title}_${lang}`).length > 0) && $(`#meta_${lang}_title`).val($(`#${title}_${lang}`).val());
			($(`#meta_${lang}_keywords`).val() == "" && $(`#${keywords}_${lang}`).length > 0) && $(`#meta_${lang}_keywords`).val($(`#${keywords}_${lang}`).val() ?? "");
			($(`#meta_${lang}_description`).val() == "" && $(`#${title}_${lang}`).length > 0) && $(`#meta_${lang}_description`).val(`${$(`#${title}_${lang}`).val()} ${$(`#${desc}_${lang}`).val() ?? ""}`);
		}
	});
};
/**
* Function : tinyMCE elFinder Browser
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.elFinderBrowser = function (callback, value, meta) {
	tinymce.activeEditor.windowManager.openUrl(
		{
			title: "File Management",
			url: '/admin/elfinder/tinymce5', // use an absolute path!
			onMessage: function (dialogApi, details) {
				if (details.mceAction === 'fileSelected') {
					const file = details.data.file;
					// Make file info
					const info = file.name;
					// Provide file and text for the link dialog
					(meta.filetype === 'file') &&
						callback(file.url, { text: info, title: info });
					// Provide image and alt text for the image dialog
					(meta.filetype === 'image') &&
						callback(file.url, { alt: info });
					// Provide alternative source and posted for the media dialog
					(meta.filetype === 'media') &&
						callback(file.url);
					dialogApi.close();
				}
			},
		}
	);
	return false;
};
/**
* Function : init Plugins tinyMCE texteditor
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initTexteditor = function () {
	($(".texteditor").length > 0) &&
		tinyMCE.init({
			selector: "textarea.texteditor",
			file_picker_callback: elFinderBrowser,
			width: '100%',
			height: 'auto',
			min_height: 340,
			max_height: 580,
			autoresize_overflow_padding: 10,
			extended_valid_elements: "i[class|style|title],iframe[src|frameborder|style|scrolling|class|width|height|name|align],svg[*],path[*],rect[*]",
			fontsize_formats: "8pt 10pt 11pt 12pt 13pt 14pt 15pt 16pt 17pt 18pt 19pt 20pt 21pt 22pt 23pt 24pt 25pt 26pt 28pt 30pt 32pt 34pt 36pt",
			plugins: [
				"advlist autoresize autolink lists link image charmap print preview anchor emoticons",
				"searchreplace visualblocks code fullscreen",
				"insertdatetime media table paste hr template",
			],
			toolbar: [
				"insertfile bootstrap",
				"undo redo | bold italic underline | alignleft aligncenter alignright alignjustify | bullist | numlist | outdent  indent | link  image  media | ",
				"forecolor backcolor | fontselect | styleselect | fontsizeselect | emoticons | fontawesome  template | "
			],
			content_style: ".container .row .col-xs-12{position:relative}.container .row .col-xs-12::before{content:'';display:block;position:absolute;height:100%;width:calc(100% - 30px);border:1px dotted gray}.container .row .col-xs-12 img{max-width:100%;height:auto}",
			templates: [
				{
					title: "1 columns",
					description: "Insert on the page, 1 columns with the same width",
					content:
						"<div class=\"container\">\
                            <div class=\"row\">\
                                <div class=\"col-12\">Column 1</div>\
                            </div>\
                        </div>",
				},
				{
					title: "2 columns",
					description: "Insert on the page, 2 columns with the same width",
					content:
						"<div class=\"container\">\
                            <div class=\"row\">\
                                <div class=\"col-sm-6\">Column 1</div><div class=\"col-sm-6\">Column 2</div>\
                            </div>\
                        </div>",
				},
				{
					title: "3 columns",
					description: "Insert on the page, 3 columns with the same width",
					content:
						"<div class=\"container\">\
                            <div class=\"row\">\
                                <div class=\"col-sm-4\">Column 1</div><div class=\"col-sm-4\">Column 2</div><div class=\"col-sm-4\">Column 3</div>\
                            </div>\
                        </div>",
				},
				{
					title: "4 columns",
					description: "Insert on the page, 4 columns with the same width",
					content:
						"<div class=\"container\">\
                            <div class=\"row\">\
                                <div class=\"col-sm-3\">Column 1</div><div class=\"col-sm-3\">Column 2</div><div class=\"col-sm-3\">Column 3</div><div class=\"col-sm-3\">Column 4</div>\
                            </div>\
                        </div>",
				},
				{
					title: "6 columns",
					description: "Insert on the page, 6 columns with the same width",
					content:
						"<div class=\"container\">\
                            <div class=\"row\">\
                                <div class=\"col-sm-2\">Column 1</div><div class=\"col-sm-2\">Column 2</div><div class=\"col-sm-2\">Column 3</div><div class=\"col-sm-2\">Column 4</div><div class=\"col-sm-2\">Column 5</div><div class=\"col-sm-2\">Column 6</div>\
                            </div>\
                        </div>",
				},
			],
			file_picker_types: 'file image media', // Allow SVG to be uploaded as a file
            image_class_list: [
                { title: 'Responsive', value: 'img-responsive' },
                { title: 'None', value: '' }
            ],
		});
	($(".select2-show-search").length > 0) && $(".select2-show-search").select2({ minimumResultsForSearch: "", });
}

/**
* Function : init navbar tab
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_nav_tab = function () {
	($(".nav").length > 0) &&
		$(".nav").each(function () {
			var name = $(this).attr("name");
			var id = $(this).attr("id");
			$('a[data-bs-toggle="tab"]').on("show.bs.tab", function (e) {
				localStorage.setItem(`${name}-${id}-tab`, $(e.target).attr("href"));
			});
			var tab = localStorage.getItem(`${name}-${id}-tab`);
			(tab != '') && $(this).find(`a[href="${tab}"]`).tab("show");
		});

}
/**
* Function : init Check Card
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_card = function () {
	$('.card-header, .card-body, .card-footer').each(function () {
		if ($(this).children().length > 0) {
			$(this).show();
		} else {
			$(this).hide();
		}
	})
}
/**
* Function : init Datepicker
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_datepicker = function () {
	($(".date-picker").length > 0) &&
		$(".date-picker").flatpickr();
	($(".datetime-picker").length > 0) &&
		$(".datetime-picker").flatpickr({ enableTime: !0, dateFormat: "Y-m-d H:i" });
	($(".range-picker").length > 0) &&
		$(".range-picker").flatpickr({ mode: "range" });
	($(".time-picker").length > 0) &&
		$(".time-picker").flatpickr({ enableTime: !0, noCalendar: !0, dateFormat: "H:i", time_24hr: !0 });
	($(".color-picker").length > 0) &&
		$(".color-picker").spectrum();
}
/**
* Function : set slug by string
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.slug = function (str) {
	str = str.replace(/[`~!@#$%^&*()_\-+=\[\]{};:'"\\|\/,.<>?\s]/g, " ").toLowerCase();
	str = str.replace(/^\s+|\s+$/gm, "");
	str = str.replace(/\s+/g, "-");
	// str = str.replace(/-\p{Emoji}/gu, ""); // Remove '-' front emoji
	// str = str.replace(/\p{Emoji}/gu, ""); // Remove emojis
	return str;
}
/**
* Function : Validate String
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.InputValidateString = function (evt) {
	/* ----------------------- Customs ------------------------*/
	// input only number and . point
	var ele = evt || window.event;
	if (ele.type === "paste") key = event.clipboardData.getData("text/plain");
	else {
		var key = ele.keyCode || ele.which;
		key = String.fromCharCode(key);
	}
	var regex = /[0-9]|\./;
	if (!regex.test(key)) {
		ele.returnValue = false;
		(ele.preventDefault) && ele.preventDefault();
	}
}
window.inputCodeRegex = function (evt) {
	var ele = evt || window.event;
	if (ele.type === "paste") key = event.clipboardData.getData("text/plain");
	else {
		var key = ele.keyCode || ele.which;
		key = String.fromCharCode(key);
	}
	var regex = /^[a-zA-Z0-9\s_]*$/;
	if (!regex.test(key)) {
		ele.returnValue = false;
		(ele.preventDefault) && ele.preventDefault();
	}
}
/**
* Function : Init Table
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_Table = function () {
	($(".dataTables_filter").length == 0) && $('.btn-search').remove();
	($('#filter-bar').length > 0) && $('.btn-frm').html($('#filter-bar').html());
	if ($('#filter-form').length > 0) {
		$('.slider-frm').each(function () {
			$(this).html($('#filter-form').html());
			$('#filter-form').remove();
			$(this).hide();
			($(this).find('.frm-filter').length == 0) &&
				$('.btn-filter').remove();
		});
		select2AjaxWithImage(".select2-ajax-with-image", true);
		$('select').each(function () {
			(!$(this).hasClass('select2-ajax-with-image')) &&
				$(this).select2({
					theme: "bootstrap-5",
					allowClear: $(this).hasClass('frm-filter'),
					placeholder: $_LANG.label.all,
					minimumResultsForSearch: Infinity,
				});
		})
	} else {
		$('.slider-frm').hide();
	}
	if ($('.frm-filter').length > 0) {
		var range;
		if ($(".range-filter").length > 0) { range = $(".range-filter").flatpickr({ mode: "range" }); }
		$('.frm-filter').change(function () {
			if ($(this).attr('id') == 'period' && $(".date-range").length > 0) {
				if ($(this).val() == 7) $(".date-range").slideDown();
				else {
					($(".range-filter").length > 0) && range.clear();
					$(".date-range").slideUp();
					setReloadDataTable(true);
				}
			} else setReloadDataTable(true);
		});
	}
	$('.btn-filter').length > 0 &&
		$('.btn-filter').click(function () {
			$('.slider-frm').slideToggle();
		});
	$('.check-all').length > 0 &&
		$('.check-all').click(function () {
			$('.table-select').prop('checked', $(this).is(":checked"));
			selectTable();
		});
}
/**
* Function : input checkbox in datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.selectTable = function () {
	$('.check-all').prop('checked', $('.table-select').toArray().every(input => $(input).is(":checked")));

	if ($('.table-select').toArray().some(input => $(input).is(":checked"))) {
		$('.btn-select').fadeIn();
	} else {
		$('.btn-select').fadeOut();
	}
}
/**
* Function : Return error 
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.ajax_error = function (xhr, status, thrown) {
	if (status == 'error' && thrown != "unknown status") {
		const resp = xhr.responseJSON;
		if (resp != undefined) {
			mwz_noti("error", resp.msg || $_LANG.noti.server_error);
		} else if (thrown != undefined) {
			mwz_noti("error", thrown);
		} else {
			mwz_noti("error", $_LANG.ajax.error);
		}
	} else {
		setTimeout(() => { window.location.reload(); }, 1500);
	}
}