$(document).ready(function () {
    initDatatable();
});
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
    // =========================  permission =========================== //
    if ($("#permission-datatable").length > 0) {
        $("#permission-datatable").DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            ajax: { url: "/admin/permission/datatable_ajax", },
            "columns": [
                { data: "DT_RowIndex", className: 'text-center' },
                { data: "name" },
                { data: "group" },
                { data: "module" },
                { data: "page" },
                { data: "action" },
                { data: "updated_at" },
                { data: "manage", orderable: false, className: 'text-center' }
            ],
            "language": $_LANG.datatable
        })
        init_Table();
    }
};
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function () {
    ($("#permission-datatable").length > 0) &&
        $("#permission-datatable").DataTable().ajax.reload(null, false);
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/permission/set_status",
        type: "POST",
        data: { id: id },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    })
};
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/permission/set_delete",
        type: "POST",
        data: { id: id, },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
};
/**
* Function : generate permission
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.generate_permission = function () {
    event.preventDefault();
    console.log('generate_permission function called');
    console.log('CSRF Token:', $('meta[name="csrf-token"]').attr("content"));
    
    $.ajax({
        url: "/admin/permission/generate",
        type: "POST",
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        beforeSend: function() {
            console.log('AJAX request starting...');
        },
        success: function (resp) { 
            console.log('AJAX success:', resp);
            mwz_noti("success", resp.msg, setReloadDataTable()); 
        },
        error: function (xhr, status, thrown) { 
            console.log('AJAX error:', xhr, status, thrown);
            ajax_error(xhr, status, thrown); 
        }
    });
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
    event.preventDefault();
    // fill metadata
    var frm = $("#permission_frm");
    var frm_data = new FormData($(frm)[0]);

    $.ajax({
        url: "/admin/permission/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        beforeSend: function (xhr) {
            // validate
            var rules = { name: { required: true, maxlength: 500, } }
            var msg = $_LANG.validate.messages;

            mwz_validate($(frm), rules, msg)
            return frm_valid($(frm));
        },
        success: function (resp) { mwz_noti("success", resp.msg, window.location.href = "/admin/permission"); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
}