
$(document).ready(function () {
    initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
    
    if ($("#province-datatable").length > 0) {
        $("#province-datatable").DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            ajax: {
                url: "/admin/province/datatable_ajax",
                data: function (d) {
                    ($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
                        (x.name != '_token') && (d[x.name] = x.value);
                    });
                }
            },
            columns: [
                { data: "DT_RowIndex", className: 'text-center' },
                { data: "name", orderable: false },
                { data: "geo_id", orderable: true },
                { data: "updated_at", orderable: true },
                { data: "action", orderable: false, className: 'text-center' }
            ],
            language: $_LANG.datatable,
        });
        init_Table();
    }
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function () {
    ($("#province-datatable").length > 0) &&
        $("#province-datatable").DataTable().ajax.reload(null, false);
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/province/set_delete",
        type: "POST",
        data: { id: id, },
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
};
/**
* Function : Sort Item
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm = $("#province_frm");
    var frm_data = new FormData($(frm)[0]);

    $.ajax({
        url: '/admin/province/save',
        type: "POST",
        data: frm_data,
        contentType: false,
        processData: false,
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
        beforeSend: function (xhr) {
            // validate
            var rules = [];
            $.each($_lang, function (i, lang) {
                rules[`name_${lang}`] = { required: true, maxlength: 255 };
            });
            rules.geo_id = { required: true };

            var msg = $_LANG.validate.messages;

            mwz_validate($(frm), rules, msg);
            return frm_valid($(frm));
        },
        success: function (resp) { mwz_noti("success", resp.msg, window.location.replace("/admin/province/")); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }

    });
};
/**
* Function : Mock data
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setProvince = function () {
    $.ajax({
        url: "/admin/province/json",
        type: "POST",
        data: {},
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        success: function (resp) { setReloadDataTable(); },
        error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
    });
}