window.MULTI_UPLOAD = {};
$(document).ready(function () {
	init_mwz_upload();
	init_mwz_multi_upload();
});
/**
* Function : delete uploaded image
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.delete_uploaded_image = function (ele, id) {
	var confirm_del_txt = $(ele).data("confirm-del-txt");
	var confirm_txt = $(ele).data("confirm-txt");
	var cancel_txt = $(ele).data("cancel-txt");
	Swal.fire({
		icon: "warning",
		title: $_LANG.delete.title,
		text: confirm_del_txt,
		showCancelButton: !0,
		confirmButtonText: confirm_txt,
		cancelButtonText: cancel_txt,
		reverseButtons: true
	}).then((result) => {
		(result.isConfirmed) &&
			delete_image(ele, id);
	})
}
/**
* Function : delete image
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.delete_image = function (ele, id) {
	var upload_txt = $(ele).data("upload-click-to-upload-txt");
	$(ele).parents("div.image-upload")
		.find(".upload_show_img_container")
		.html(`<div class=\"d-upload-image\"><i class=\"mdi mdi-cloud-upload-outline\"></i><p><b>${upload_txt}</b></p></div>`);
	$(ele).hide();
	$(`#upload_image${id}`).val("");
	$(`#upload_image${id}_del`).val(1);
}
window.init_mwz_upload = function () {
	if ($(".mwz-image-upload").length > 0) {
		$(".mwz-image-upload").each(function () {
			var data_id = $(this).data("id");
			var size = parseInt($(this).data("size"));

			var upload_light_gallery = $(this).find(".upload_lightgallery");
			var file_input = $(this).find('input[type="file"]')[0];
			file_input.onchange = (evt) => {
				const [file] = file_input.files;
				var url = URL.createObjectURL(file);

				if (file) {
					if (typeof size !== 'undefined' && size != 0) {
						if (file_input.files[0].size > (size * (1024 * 1024))) {
							mwz_noti('error', $_LANG.noti.file_too_large);
							return
						}
					}
					
					// Check against common PHP upload limits (default 2MB if not specified)
					var maxFileSize = 2 * 1024 * 1024; // 2MB default
					if (typeof window.maxUploadSize !== 'undefined') {
						maxFileSize = window.maxUploadSize;
					}
					if (file_input.files[0].size > maxFileSize) {
						var errorMessage = 'File size exceeds the maximum allowed limit';
						if (typeof $_LANG !== 'undefined' && $_LANG.noti && $_LANG.noti.file_too_large) {
							errorMessage = $_LANG.noti.file_too_large;
						}
						mwz_noti('error', errorMessage);
						return
					}
					var html = '<p>';
					if (file_input.files[0].type.match("image.*")) {
						html += `<b><img id=\"blah\" class=\"img-responsive\" src=\"${url}\" /></b>`;
					} else if (file_input.files[0].type.match("audio/*")) {
						html += "<b><i class=\"fe-play-circle fs-1\"></i></b>";
					} else if (file_input.files[0].type.match("video/*")) {
						html += `<div class=\"embed-responsive embed-responsive-4by3\"><video src=\"${url}\" controls></video></div>`;
					} else {
						html += "<b><i class=\"fe-file-text fs-1\"></i></b>";
					}
					html += '</p>';
					$(this).find('.d-upload-image').html(html);

					$("#btn_delete" + data_id).show();
				}
			};
			$("#btn_delete" + data_id).bind("click", function () {
				delete_uploaded_image($(this), data_id);
			});
			(upload_light_gallery.length > 0) && lightGallery(upload_light_gallery);
		});
	}
}
/**
* Function : init mwz multi upload
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_mwz_multi_upload = function () {
	$(".dropzone").each(function () {
		var myDropZone;
		var ele = this;
		var this_form = $(this).closest("form");
		var action = $(this).data("action");
		var acceptedFiles = $(this).data("accepted-files");
		var paramName = $(this).data("param-name");
		var maxFiles = $(this).data("max-file");
		var uploadMsg = $(this).data("upload-msg");
		var maxFileMsg = $(this).data("max-file-msg");
		var thumbnailPath = $(this).data("thumbnail-path");
		var files_list = [];
		($(ele).find("input.file_list").val() != "") &&
			(files_list = JSON.parse($(ele).find("input.file_list").val()));
		var current_drop_zone = {};
		current_drop_zone["element"] = $(ele).dropzone({
			url: action,
			previewTemplate: document.getElementById("preview-template").innerHTML,
			autoProcessQueue: false,
			acceptedFiles: acceptedFiles,
			addRemoveLinks: true,
			uploadMultiple: true,
			parallelUploads: maxFiles,
			maxFiles: maxFiles,
			paramName: paramName,
			dictDefaultMessage: '<i class=\"mdi mdi-cloud-upload-outline\"></i> ' + uploadMsg,
			dictRemoveFile: "<i class=\"fe-x\"></i>",
			dictMaxFilesExceeded: maxFileMsg,
			init: function () {
				myDropZone = this;
				current_drop_zone["object"] = myDropZone;

				var container = myDropZone.element;
				$(container).attr("data-image-cnt", 0);
				var file_removed = [];

				// add element to form
				this.on("addedfile", function (file, responseText) {
					var cnt = $(ele).find("div.dz-preview").length;
					if (cnt <= maxFiles) {
						$(file.previewElement).attr("id", `file_${cnt}`);
						$(file.previewElement).find("input").each(function () {
							var name = `${paramName}_${$(this).data("name")}[${cnt}]`;
							var id = `${paramName}_${$(this).data("name")}_${cnt}`;
							$(this).attr("name", name);
							$(this).attr("id", id);
							(typeof file[$(this).data("name")] != "undefined") &&
								$(this).val(file[$(this).data("name")]);
						});
					} else this.removeFile(file);
				});
				this.on("maxfilesexceeded", function (file, responseText) {
					this.removeFile(file);
				});
				this.on("sendingmultiple", function (data, xhr, formData) {
					// add element to form
					let form = $(this_form).serializeArray();
					for (var i = 0; i < form.length; i++) {
						formData.append(form[i].name, form[i].value);
					}
				});
				this.on("removedfile", function (file) {
					if (file.complete) { file_removed.push(file.image); }
					else { file_removed.push(file.name); }
					$(ele).find("input.file_removed").val(JSON.stringify(file_removed));
				});
				this.on("completemultiple", function (file, responseText) {
				});
				this.on("queuecomplete", function (file, responseText) {
				});
				// init file
				if (files_list != null && files_list.length > 0) {
					$.each(files_list, function (index, mockFile) {
						var cnt = $(ele).find("div.dz-preview").length;
						if (cnt <= maxFiles) {
							myDropZone.emit("addedfile", mockFile);
							myDropZone.emit("thumbnail", mockFile, `${thumbnailPath}${mockFile.image}`);
							myDropZone.emit("complete", mockFile);
						}
					});
				}
			},
		});
		$(ele).sortable({
			items: ".dz-preview",
			cursor: "move",
			opacity: 0.5,
			containment: "parent",
			distance: 20,
			tolerance: "pointer",
			stop: function () {
				var queue = myDropZone.files;
				var newQueue = [];
				$(".dropzone .dz-preview .dz-filename [data-dz-name]").each(function (count, el) {
					var name = el.innerHTML;
					queue.forEach(function (file) { (file.name === name) && newQueue.push(file); });
				});
				myDropZone.files = newQueue;
				// resort file in list
				var file_sort = [];
				$(ele).find("div.dz-preview").each(function (index) {
					var img = {
						index: index,
						complete: $(this).hasClass("dz-complete"),
						image: $(this).find(".dz-image").children().attr("src"),
						name: $(this).find("span[data-dz-name]").html(),
					};
					$(this).find("input").each(function () { img[$(this).data("name")] = $(this).val() });
					file_sort.push(img);
				});
				$(ele).find("input.file_list").val(JSON.stringify(file_sort));
			},
		});

		MULTI_UPLOAD[paramName] = current_drop_zone;
	});
}
/**
* Function : mwz multi upload process
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwz_multi_upload_process = function (ele, resp) {
	// update file list before send
	var myDropZone = ele["element"];
	var ele = ele["object"];

	var file_sort = [];
	$(myDropZone).find("div.dz-preview").each(function (index) {
		var img = {
			index: index,
			complete: $(this).hasClass("dz-complete"),
			image: $(this).find(".dz-image").children().attr("src"),
			name: $(this).find("span[data-dz-name]").html(),
		};
		$(this).find("input").each(function () {
			img[$(this).data("name")] = $(this).val()
		});
		file_sort.push(img);
	});
	$(myDropZone).find("input.file_list").val(JSON.stringify(file_sort));
	// upload file
	if (ele.getQueuedFiles().length > 0) ele.processQueue();
	else multiFileUploadCallBack({}, resp);
	// upload finish
	ele.on("successmultiple", function (file, resp) {
		if ($.isFunction(multiFileUploadCallBack)) { multiFileUploadCallBack(file, resp); }
	});
}