window.cities = [];
$(document).ready(function () {
    init_address()
    mwz_zipcode();
    init_district();
})
/**
* Function : mwz zipcode
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.mwz_zipcode = function () {
    if ($(".mwz-zipcode").length > 0)
        $(document).find(".mwz-zipcode").keyup(function () {
            var frm = $(this).closest(".form-address");
            var geo = $(frm).find('.mwz-geo');
            var province = $(frm).find('.mwz-province');
            var district = $(frm).find('.mwz-district');
            var city = $(frm).find('.mwz-city');
            var frmID = $(frm).data('id');
            var zipcode = $(this);
            if ($(zipcode).val().length == 5) {
                $.ajax({
                    url: '/admin/city/mwz_zipcode',
                    type: "POST",
                    data: { zipcode: $(frm).find('.mwz-zipcode').val() },
                    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                    success: function (resp) {
                        cities[frmID] = resp.city;
                        ($(geo).length > 0) && fomateSelect2data(geo, resp.geo), $(geo).prop('disabled', false);
                        ($(province).length > 0) && fomateSelect2data(province, resp.province), $(province).prop('disabled', false);
                        ($(district).length > 0) && fomateSelect2data(district, resp.district), $(district).prop('disabled', false);
                        ($(city).length > 0) && fomateSelect2data(city, resp.city), $(city).prop('disabled', false), $(district).change();
                    },
                    error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
                })
            } else {
                ($(geo).length > 0) && $(geo).prop('disabled', true).empty();
                ($(province).length > 0) && $(province).prop('disabled', true).empty();
                ($(district).length > 0) && $(district).prop('disabled', true).empty();
                ($(city).length > 0) && $(city).prop('disabled', true).empty();
            }
        })
}
/**
* Function : init address
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_address = function () {
    ($('.mwz-geo').length > 0) && fomate_select2('.mwz-geo');
    ($('.mwz-province').length > 0) && fomate_select2('.mwz-province');
    ($('.mwz-district').length > 0) && fomate_select2('.mwz-district');
    ($('.mwz-city').length > 0) && fomate_select2('.mwz-city');
}
/**
* Function : fomate select2
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.fomate_select2 = function (name) {
    $(name).each(function () {
        var placeholder = $(this).attr('placeholder');
        var ele = $(this).select2({
            theme: "bootstrap-5",
            minimumResultsForSearch: Infinity,
            placeholder: placeholder,
            minimumInputLength: 0,
            language: {
                searching: function () { return $_LANG.action.loading },
                noResults: function () { return $_LANG.action.zeroRecords },
            },
        });
        var option_id = $(this).data("id");
        var option_text = $(this).data("text");
        if (option_id != "") {
            $(ele).append(new Option(option_text, option_id, true, true))
            $(ele).prop('disabled', $(ele).is(":disabled"));
        } else { $(ele).prop('disabled', true); }

    });
}
/**
* Function : fomate Select2 data
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.fomateSelect2data = function (ele, data) {
    $.each(data, function (index, e) {
        if (index == 0) { $(ele).append(new Option(e.text, e.id, true, true)); }
        else { $(ele).append(new Option(e.text, e.id, false, false)); }
    })
}
/**
* Function : init district
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.init_district = function () {
    $(document).find('.mwz-district').each(function (index) {
        var frm = $(this).closest(".form-address");
        $(this).change(function () {
            var frmID = $(frm).data('id');
            var ele = $(frm).find('.mwz-city');
            $(ele).empty();
            var val = $(this).val();
            $.each(cities[frmID], function (index, e) {
                if (val == e.district_id) {
                    if (index == 0) { $(ele).append(new Option(e.text, e.id, true, true)); }
                    else { $(ele).append(new Option(e.text, e.id, false, false)); }
                }
            })
        });
    })
}
