@extends('tree.app')

@section('styles')
@endsection

@section('content')
    @include('mwz::menu.tree.navbar')
    <div class="row">
        <div class="col-md-9">
            <div class="card card-body">
                @if (!empty($data))
                    <div id="tree_view">

                        <ul>
                            @foreach ($data as $item)
                                @if (!empty($item->children) && $item->children->count())
                                    <li data-id="{{ $item->id }}"
                                        data-jstree='{"opened":true,"icon":"fas fa-chevron-circle-right"}'>
                                        <a>{{ $item->name ?? '' }}</a>
                                        @include('mwz::menu.tree.children', ['param' => $item->children])
                                    </li>
                                @else
                                    <li data-id="{{ $item->id }}"
                                        data-jstree='{"opened":true,"icon":"fas fa-chevron-circle-right"}'>
                                        {{ $item->name }}</li>
                                @endif
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('build/mwz/menu.js') }}"></script>
@endsection
