<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	Route::get('/home', 'AdminController@homepage')->name('admin.homepage');

	Route::prefix('mwz')->group(function () {
		Route::post('/address', 'MwzAdminController@address')->name('admin.mwz.address');
		Route::get('/province', 'MwzAdminController@province')->name('admin.mwz.province');
	});
	Route::prefix('admin_menu')->group(function () {
		Route::get('/', 'AdminMenuController@index')->name('admin.mwz.admin_menu.index');
		Route::get('/datatable_ajax', 'AdminMenuController@datatable_ajax')->name('admin.mwz.admin_menu.datatable_ajax');

		Route::get('/add', 'AdminMenuController@form')->name('admin.mwz.admin_menu.add');
		Route::get('/edit/{id}', 'AdminMenuController@form')->name('admin.mwz.admin_menu.edit');
		Route::post('/save', 'AdminMenuController@save')->name('admin.mwz.admin_menu.save');

		Route::get('/tree', 'AdminMenuController@tree')->name('admin.mwz.admin_menu.tree');
		Route::post('/tree/sort', 'AdminMenuController@tree_sort')->name('admin.mwz.admin_menu.tree_sort');

		Route::post('/set_sort', 'AdminMenuController@set_sort')->name('admin.mwz.admin_menu.set_sort');
		Route::post('/set_status', 'AdminMenuController@set_status')->name('admin.mwz.admin_menu.set_status');
		Route::post('/set_delete', 'AdminMenuController@set_delete')->name('admin.mwz.admin_menu.set_delete');

		Route::post('/get_list', 'AdminMenuController@get_list')->name('admin.mwz.admin_menu.get_list');

		Route::get('/icons', 'AdminMenuController@icons')->name('admin.mwz.admin_menu.icons');
	});

	Route::prefix('slug')->group(function () {
		Route::get('/', 'SlugAdminController@index')->name('admin.mwz.slug.index');
		Route::get('/datatable_ajax', 'SlugAdminController@datatable_ajax')->name('admin.mwz.slug.datatable_ajax');

		Route::get('/add', 'SlugAdminController@form')->name('admin.mwz.slug.add');
		Route::get('/edit/{uid}', 'SlugAdminController@form')->name('admin.mwz.slug.edit');
		Route::post('/save', 'SlugAdminController@save')->name('admin.mwz.slug.save');

		Route::post('/set_delete', 'SlugAdminController@set_delete')->name('admin.mwz.slug.set_delete');
		Route::get('/generate/sitemap', 'SlugAdminController@generate_sitemap')->name('admin.mwz.slug.sitemap');

		Route::get('/generate', 'SlugAdminController@generate')->name('admin.mwz.slug.generate');

		Route::post('/get_list', 'SlugAdminController@get_list')->name('admin.mwz.slug.get_list');
	});
	Route::prefix('permission')->group(function () {
		Route::get('/', 'PermissionAdminController@index')->name('admin.mwz.permission.index');
		Route::get('/datatable_ajax', 'PermissionAdminController@datatable_ajax')->name('admin.mwz.permission.datatable_ajax');

		Route::get('/add', 'PermissionAdminController@form')->name('admin.mwz.permission.add');
		Route::get('/edit/{id}', 'PermissionAdminController@form')->name('admin.mwz.permission.edit');
		Route::post('/save', 'PermissionAdminController@save')->name('admin.mwz.permission.save');

		Route::post('/set_status', 'PermissionAdminController@set_status')->name('admin.mwz.permission.set_status');
		Route::post('/set_delete', 'PermissionAdminController@set_delete')->name('admin.mwz.permission.set_delete');

		Route::post('/get_list', 'PermissionAdminController@get_list')->name('admin.mwz.permission.get_list');
		Route::post('/get_route', 'PermissionAdminController@get_route')->name('admin.mwz.permission.get_route');

		Route::post('/generate', 'PermissionAdminController@generate')->name('admin.mwz.permission.generate');
	});

	Route::prefix('geo')->group(function () {
		Route::get('/', 'GeographyAdminController@index')->name('admin.mwz.geo.index');
		Route::get('/datatable_ajax', 'GeographyAdminController@datatable_ajax')->name('admin.mwz.geo.datatable_ajax');

		Route::get('/add', 'GeographyAdminController@form')->name('admin.mwz.geo.add');
		Route::get('/edit/{id}', 'GeographyAdminController@form')->name('admin.mwz.geo.edit');

		Route::post('/save', 'GeographyAdminController@save')->name('admin.mwz.geo.save');
		Route::post('/set_delete', 'GeographyAdminController@set_delete')->name('admin.mwz.geo.set_delete');

		Route::post('/get_list', 'GeographyAdminController@get_list')->name('admin.mwz.geo.get_list');

		Route::post('/json', 'GeographyAdminController@json');
	});
	Route::prefix('province')->group(function () {
		Route::get('/', 'ProvinceAdminController@index')->name('admin.mwz.province.index');
		Route::get('/datatable_ajax', 'ProvinceAdminController@datatable_ajax')->name('admin.mwz.province.datatable_ajax');

		Route::get('/add', 'ProvinceAdminController@form')->name('admin.mwz.province.add');
		Route::get('/edit/{id}', 'ProvinceAdminController@form')->name('admin.mwz.province.edit');

		Route::post('/save', 'ProvinceAdminController@save')->name('admin.mwz.province.save');
		Route::post('/set_delete', 'ProvinceAdminController@set_delete')->name('admin.mwz.province.set_delete');

		Route::post('/get_list', 'ProvinceAdminController@get_list')->name('admin.mwz.province.get_list');

		Route::post('/json', 'ProvinceAdminController@json');
	});
	Route::prefix('district')->group(function () {
		Route::get('/', 'DistrictAdminController@index')->name('admin.mwz.district.index');
		Route::get('/datatable_ajax', 'DistrictAdminController@datatable_ajax')->name('admin.mwz.district.datatable_ajax');

		Route::get('/add', 'DistrictAdminController@form')->name('admin.mwz.district.add');
		Route::get('/edit/{id}', 'DistrictAdminController@form')->name('admin.mwz.district.edit');

		Route::post('/save', 'DistrictAdminController@save')->name('admin.mwz.district.save');
		Route::post('/set_delete', 'DistrictAdminController@set_delete')->name('admin.mwz.district.set_delete');

		Route::post('/get_list', 'DistrictAdminController@get_list')->name('admin.mwz.district.get_list');

		Route::post('/json', 'DistrictAdminController@json');
	});
	Route::prefix('city')->group(function () {
		Route::get('/', 'CityAdminController@index')->name('admin.mwz.city.index');
		Route::get('/datatable_ajax', 'CityAdminController@datatable_ajax')->name('admin.mwz.city.datatable_ajax');

		Route::get('/add', 'CityAdminController@form')->name('admin.mwz.city.add');
		Route::get('/edit/{id}', 'CityAdminController@form')->name('admin.mwz.city.edit');

		Route::post('/save', 'CityAdminController@save')->name('admin.mwz.city.save');
		Route::post('/set_delete', 'CityAdminController@set_delete')->name('admin.mwz.city.set_delete');

		Route::post('/get_list', 'CityAdminController@get_list')->name('admin.mwz.city.get_list');

		Route::post('/json', 'CityAdminController@json');

		Route::post('/mwz_zipcode', 'CityAdminController@mwz_zipcode')->name('admin.mwz.city.mwz_zipcode');
	});
});



Route::group(['prefix' => 'api', 'middleware' => 'apiLocale'], function () {
	Route::post('/address', 'MwzController@address')->name('api.address');
});
