<?php

namespace Modules\OilPrice\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Member\app\Models\MemberLavel;
use Modules\OilPrice\Database\factories\OilPriceFactory;

class OilPrice extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     */
    protected $table = 'oilprice';
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'scheme_type',
        'gap_range',
        'gap_min',
        'gap_max',
        'reference',
        'range_min',
        'range_max',
        'value_a',
        'value_b',
        'value_c',
        'rate',
        'gap_value',
        'km_l',
        'multiplier',
        'currency',
        'rate_per_km',
        'credit',
        'remark',
        'status',
        'default',
    ];


    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'gap_min' => 'decimal:2',
        'gap_max' => 'decimal:2',
        'reference' => 'decimal:2',
        'range_min' => 'decimal:2',
        'range_max' => 'decimal:2',
        'value_a' => 'decimal:2',
        'value_b' => 'decimal:2',
        'value_c' => 'decimal:2',
        'rate' => 'decimal:2',
        'gap_value' => 'decimal:2',
        'km_l' => 'decimal:2',
        'multiplier' => 'decimal:2',
        'rate_per_km' => 'decimal:2',
        'credit' => 'decimal:2',
        'status' => 'boolean',
    ];
    
    protected static function newFactory(): OilPriceFactory
    {
        //return OilPriceFactory::new();
    }

    public function oilprice_abc_checked()
    {
        return $this->hasMany(OilpriceAbc::class, 'role_id', 'id');
    }

    public function scheme_type_name()
    {
        return $this->belongsTo(MemberLavel::class, 'scheme_type', 'id');
    }
}
