<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('oilprice', function (Blueprint $table) {
            $table->id();
            
            // Basic information
            $table->string('scheme_type')->comment('ประเภทโครงการ: manager, sale');
            
            // Gap/Age range
            $table->string('gap_range')->nullable()->comment('ช่วงเช่น 10-14.99');
            $table->decimal('gap_min', 8, 2)->nullable()->comment('ขั้นต่ำ');
            $table->decimal('gap_max', 8, 2)->nullable()->comment('สูงสุด');
                
                // Reference values
            $table->decimal('reference', 8, 2)->nullable()->comment('ราคาน้ำมัน');
            
            // Scheme columns (ใช้ร่วมกันสำหรับทุก scheme_type)
            $table->decimal('range_min', 8, 2)->nullable()->comment('ช่วงขั้นต่ำ');
            $table->decimal('range_max', 8, 2)->nullable()->comment('ช่วงสูงสุด');
            $table->decimal('value_a', 8, 2)->nullable()->comment('ค่า A');
            $table->decimal('value_b', 8, 2)->nullable()->comment('ค่า B');
            $table->decimal('value_c', 8, 2)->nullable()->comment('ค่า C');
            $table->decimal('rate', 8, 2)->nullable()->comment('อัตรา (Rate)');
            
            // GAP calculation
            $table->decimal('gap_value', 8, 2)->nullable()->comment('ค่า GAP');
            
            // Top level rates (from the summary table)
            $table->decimal('km_l', 8, 2)->nullable()->comment('A: อัตราการใช้เชื้อเพลิง Km/L');
            $table->decimal('multiplier', 8, 2)->default(1.20)->comment('B: ตัวคูณ');
            $table->decimal('rate_per_km', 8, 2)->nullable()->comment('C: อัตราต่อกิโลเมตร THB/Km');
            $table->decimal('credit', 8, 2)->nullable()->comment('เชื่อ (Credit)');
            $table->string('currency', 10)->default('THB/Km')->comment('หน่วยเงิน');
            
            // Additional information
            $table->text('remark')->nullable()->comment('หมายเหตุ');
            $table->boolean('status')->default(true)->comment('สถานะใช้งาน');
            
            $table->timestamps();
            
            // Indexes for better query performance
            $table->index('scheme_type');
            $table->index('gap_range');
            $table->index(['gap_min', 'gap_max']);
            $table->index('status');
        });

        Schema::create('oilprice_abc', function (Blueprint $table) {
            $table->id();
            $table->integer('role_id');
            $table->string('name');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('oilprice');
        Schema::dropIfExists('oilprice_abc');
    }
};
