$(document).ready(function () {
	console.log("=== oil.js loaded! ===");
	initDatatable();
	($('[name="style"]').length > 0) && $('[name="style"]').change();

	// Auto-fill gap_min and gap_max from gap_range
	console.log("Checking for gap_range input...");
	console.log("$('#gap_range').length:", $("#gap_range").length);
	console.log("$('[name=\"gap_range\"]').length:", $('[name="gap_range"]').length);
	
	if ($("#gap_range").length > 0) {
		console.log("✓ gap_range input FOUND! Setting up change event...");
		
		$("#gap_range").on("change", function () {
			console.log("=== gap_range CHANGED! ===");
			var gap_range = $(this).val();
			console.log("Input value:", gap_range);
			
			var gap_min = gap_range.split('-')[0];
			var gap_max = gap_range.split('-')[1];
			console.log("Parsed - gap_min:", gap_min, "gap_max:", gap_max);
			
			$('[name="gap_min"]').val(gap_min);
			$('[name="gap_max"]').val(gap_max);
			console.log("Values set successfully!");
		});
	} else {
		console.log("✗ gap_range input NOT FOUND (หน้านี้ไม่มี input gap_range)");
	}

})


window.initDatatable = function () {

	if ($(`#${$_name}-datatable`).length > 0) {
		let column = [{ data: "DT_RowIndex", className: 'text-center' }];

		$_config.table.header.forEach((e) => {
			if (e.status)
				column.push({ data: e.column, orderable: e.orderable, className: e.class ?? '' });
		});
		($_config.table.btn.sort) && column.push({ data: "sort", orderable: false, className: 'text-center' });
		column.push(
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		let cfg = {
			processing: true,
			serverSide: true,
			stateSave: true,
			columnDefs: [
				{ orderable: true, className: "reorder", targets: 0 },
				{ orderable: false, targets: "_all" },
			],
			ajax: {
				url: $_link_datatable,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		};

		const oTable = $(`#${$_name}-datatable`).DataTable(cfg);
		init_Table();
	}
}


window.setReloadDataTable = function (bool = false) {
	($(`#${$_name}-datatable`).length > 0) && $(`#${$_name}-datatable`).DataTable().ajax.reload(null, bool);
}

window.setSort = function (id, move) {
	event.preventDefault();

	if ($_link_sort.length > 0) {
		$.ajax({
			url: $_link_sort,
			type: "POST",
			data: { id: id, move: move },
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	};
};

window.setDefault = function (id) {
	event.preventDefault();

	if ($_link_default.length > 0) {
		$.ajax({
			url: $_link_default,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setStatus = function (id) {
	event.preventDefault();

	if ($_link_status.length > 0) {
		$.ajax({
			url: $_link_status,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setDelete = function (id) {
	event.preventDefault();

	if ($_link_delete.length > 0) {
		$.ajax({
			url: $_link_delete,
			type: "POST",
			data: { id: id, },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());

				if (resp.limit)
					$(`#add`).removeClass('d-none');
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	if ($_link_save.length > 0) {
		$(`#submit`).prop('disabled', true);
		const frm = $(`#${$_name}_frm`);
		const frm_data = new FormData($(frm)[0]);

		$.ajax({
			url: $_link_save,
			type: "POST",
			data: frm_data,
			contentType: false,
			processData: false,
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			beforeSend: function (xhr) {
				let rules = [], msg = [];

				// Validate basic inputs
				if ($_config.form.navbar.basic && $_config.form.navbar.basic.status) {
					$.each($_config.form.navbar.basic.input, function (k, e) {
						if (e.status && e.validate) {
							rules[`${k}`] = { required: true };
							msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
						}
					});
				}

				// Validate scheme inputs
				if ($_config.form.navbar.scheme && $_config.form.navbar.scheme.status) {
					$.each($_config.form.navbar.scheme.input, function (k, e) {
						if (e.status && e.validate) {
							rules[`${k}`] = { required: true };
							msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
						}
					});
				}

				// Validate rates inputs
				if ($_config.form.navbar.rates && $_config.form.navbar.rates.status) {
					$.each($_config.form.navbar.rates.input, function (k, e) {
						if (e.status && e.validate) {
							rules[`${k}`] = { required: true };
							msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
						}
					});
				}

				// Validate other inputs
				if ($_config.form.navbar.other && $_config.form.navbar.other.status) {
					$.each($_config.form.navbar.other.input, function (k, e) {
						if (e.status && e.validate) {
							rules[`${k}`] = { required: true };
							msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
						}
					});
				}

				// Validate sidebar settings
				if ($_config.form.sidebar.setting && $_config.form.sidebar.setting.status) {
					$.each($_config.form.sidebar.setting.input, function (k, e) {
						if (e.status && e.validate) {
							rules[`${k}`] = { required: true };
							msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
						}
					});
				}

				mwz_validate($(frm), rules, msg);

				if (!frm_valid($(frm))) {
					$(`#submit`).prop('disabled', false);
					return false;
				}

				return true;
			},
			success: function (resp) {
				$(frm).find("#id").val(resp.id);
				// Check if upload section exists before using it
				if ($_config.form.navbar.upload && $_config.form.navbar.upload.status && $_config.form.navbar.upload.input.gallery && $_config.form.navbar.upload.input.gallery.status && $('#gallery').length > 0) {
					mwz_multi_upload_process(MULTI_UPLOAD["gallery"], resp);
				} else {
					save_return(resp);
				}
			},
			error: function (xhr, status, thrown) {
				$(`#submit`).prop('disabled', false);
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.multiFileUploadCallBack = function (file, resp) {
	save_return(resp);
}

window.save_return = function (resp) {
	mwz_noti("success", resp.msg, window.location.replace(resp.url));
}

window.$('[name="style"]').change(function (e) {
	e.preventDefault();
	const id = $(this).val();

	($('.link').length > 0) && $('.link')[id == 1 ? 'fadeIn' : 'fadeOut']();
	if ($('.tab-style').length > 0) {
		$('.tab-style').removeClass('active');
		$('.tab-style').each(function () {
			console.log($(this).data('id'));
			($(this).data('id') == id) && $(this).addClass('active');
		})
	}

	init_card();
});

/**
 * Export oil price data to Excel
 */
window.exportMember = function () {
	// Get filter values
	let params = [];
	
	// Get search value
	const searchValue = $(`#${$_name}-datatable_filter input`).val();
	if (searchValue) {
		params.push('search=' + encodeURIComponent(searchValue));
	}
	
	// Get scheme_type filter if exists
	if ($('[name="scheme_type"]').length > 0) {
		const schemeType = $('[name="scheme_type"]').val();
		if (schemeType) {
			params.push('scheme_type=' + encodeURIComponent(schemeType));
		}
	}
	
	// Build URL with parameters
	const url = $_link_export + (params.length > 0 ? '?' + params.join('&') : '');
	window.location.href = url;
};

/**
 * Import members from Excel/CSV
 */
window.importMember = function () {
	$('#importModal').modal('show');
};

/**
 * Download import template
 */
window.downloadTemplate = function () {
	window.location.href = $_link_download_template;
};

/**
 * Handle import file upload
 */
window.handleImportUpload = function () {
	const fileInput = document.getElementById('importFile');
	const file = fileInput.files[0];

	console.log('Import function called');
	console.log('File:', file);

	if (!file) {
		mwz_noti('error', 'กรุณาเลือกไฟล์');
		return;
	}

	// Check file extension
	const validExtensions = ['xlsx', 'xls', 'csv'];
	const fileName = file.name;
	const fileExtension = fileName.split('.').pop().toLowerCase();

	console.log('File extension:', fileExtension);

	if (!validExtensions.includes(fileExtension)) {
		mwz_noti('error', 'รองรับเฉพาะไฟล์ .xlsx, .xls และ .csv เท่านั้น');
		return;
	}

	// Check file size (max 10MB)
	if (file.size > 10 * 1024 * 1024) {
		mwz_noti('error', 'ขนาดไฟล์ต้องไม่เกิน 10MB');
		return;
	}

	const formData = new FormData();
	formData.append('file', file);

	console.log('Import URL:', $_link_import);

	$('#importBtn').prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> กำลังนำเข้า...');

	$.ajax({
		url: $_link_import,
		type: 'POST',
		data: formData,
		contentType: false,
		processData: false,
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		success: function (resp) {
			console.log('Import success response:', resp);
			
			$('#importModal').modal('hide');
			$('#importFile').val('');
			$('#importBtn').prop('disabled', false).html('<i class="mdi mdi-file-import-outline"></i> นำเข้าข้อมูล');

			let message = resp.msg;
			if (resp.errors && resp.errors.length > 0) {
				message += '<br><br><span style="color: #dc3545; font-weight: bold;">ข้อผิดพลาด:</span><br>';
				resp.errors.forEach(function (error) {
					message += `<span style="color: #dc3545;">แถว ${error.row}: ${error.message}</span><br>`;
				});
			}
			// Reload datatable first
			setReloadDataTable();
			// Then show notification
			mwz_noti('success', message);
		},
		error: function (xhr, status, thrown) {
			console.log('Import error:', xhr, status, thrown);
			console.log('Response:', xhr.responseJSON);
			
			$('#importBtn').prop('disabled', false).html('<i class="mdi mdi-file-import-outline"></i> นำเข้าข้อมูล');
			ajax_error(xhr, status, thrown);
		}
	});
};