@extends('table.app')

@section('styles')
    <!-- datatable re order -->
    <link href="{{ asset('assets/libs/datatable-reorder/rowReorder.dataTables.min.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <!-- table -->
    @includeIf('oilprice::table.table')
    <!-- table -->

    <!-- filter -->
    @includeIf('oilprice::table.filter')
    <!-- filter -->
@endsection

@section('scripts')
    <script src="{{ asset('assets/libs/datatable-reorder/dataTables.rowReorder.min.js') }}"></script>

    <script>
        const $_name = '<?= $method ?>';
        const $_type = '<?= $type ?>';
        const $_config = $.parseJSON('<?= json_encode($config) ?>');

        // link action
        const $_link_datatable = '{{ route("admin.{$type}.{$method}.datatable_ajax") }}';
        const $_link_sort = '{{ route("admin.{$type}.{$method}.set_sort") }}';
        const $_link_default = '{{ route("admin.{$type}.{$method}.set_default") }}';
        const $_link_status = '{{ route("admin.{$type}.{$method}.set_status") }}';
        const $_link_delete = '{{ route("admin.{$type}.{$method}.set_delete") }}';
    </script>

    {{ module_vite("build-oilprice", "resources/assets/js/{$method}.js") }}
@endsection
