<?php

namespace Modules\Policy\app\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;
use Modules\Policy\app\Models\Policy;
use Modules\Policy\app\Models\PolicyTranslate;

class PolicyAdminController extends AdminController
{
	private $config;

	/**
	 * Function : construct
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function __construct()
	{
		$this->middleware('auth:admin');

		self::$navbar = [
			['name' => __("policy::policy.title"), 'url' => null],
			['name' => __("policy::policy.name"), 'url' => route_has("admin.policy.policy.index")]
		];

		$this->config = config("policy.policy");
	}

	/**
	 * Function : index
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function index()
	{
		$meta = $this->set_metadata('policy', 'policy', 1);
		$data = Policy::orderBy('created_at', 'desc')->first();
		if (!empty($data->langs)) {
			$data->langs = $data->langs->groupBy('lang')->map(function ($row) {
				return  $row->first();
			});
		}
		$meta = array_merge($meta, SlugController::getMetadata('policy', 'policy', 1));

		return view('policy::policy.index', ['data' => $data, 'navbar' => self::$navbar, 'config' => $this->config, 'meta' => $meta]);
	}

	/**
	 * Function : save
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function save(Request $request)
	{
		$rule = $msg = [];
		foreach (languages() as $lang => $l) {
			foreach ($this->config['input'] as $key => $item) {
				if (!empty($item['status']) && !empty($item['validate'])) {
					$rule["{$key}_{$lang}"] = $key == 'name' ? 'required|max:255' : 'required';
					$msg["{$key}_{$lang}"] = __("field.{$key}_placeholder") . ' ' . ($l['name'] ?? '');
				}
			}
			foreach ($this->config['content'] as $key => $item) {
				if (!empty($item['status']) && !empty($item['translate'])) {
					$rule["{$key}_{$lang}"] = $key == 'name' ? 'required|max:255' : 'required';
					$msg["{$key}_{$lang}"] = __("field.{$key}_placeholder") . ' ' . ($l['name'] ?? '');
				}
			}
		}

		//validate post data
		$valid = validator($request->all(), $rule, $msg);
		if ($valid->fails()) {
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
		}

		$attr['status'] = $request->get('status') ?? 0;

		// แก้ไขตรงนี้: แทนที่จะ create ให้อัปเดตหรือสร้างใหม่ด้วย id 1 เสมอ
		$set = Policy::updateOrCreate(['id' => 1], $attr);

		if ($set) {
			self::setLangs($request, $set);
			if ($this->config['seo']) {
				SlugController::createMetadata($request, 1);
			}
			return self::response(['msg' => __('noti.success')], 200);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}

	private static function clear_data(int $item = 5)
	{
		$datas = Policy::orderBy('created_at', 'desc')->get();
		foreach ($datas as $k => $data) {
			if ($k >= $item) {
				$data->langs()->delete();
				$data->delete();
			}
		}
	}

	/**
	 * Function : set translate
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	private function setLangs(Request $request, $row)
	{
		foreach (languages() as $lang => $item) {
			$attr = [];
			foreach ($this->config['input'] as $key => $item) {
				$attr[$key] = mwz_setTextString($request->get("{$key}_{$lang}") ?? '', $item['type'] == 'texteditor');
			}
			foreach ($this->config['content'] as $key => $item) {
				$attr[$key] = mwz_setTextString($request->get("{$key}_{$lang}") ?? '', $item['type'] == 'texteditor');
			}
			$row->langs()->updateOrCreate(['lang' => $lang], $attr);
		}
	}
}
