<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Policy\Database\factories\MarketingTranslateFactory;

class MarketingTranslate extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['id', 'marketing_id', 'lang', 'name', 'desc', 'detail', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "marketing_translate";
    protected $primaryKey = "id";

    protected static function newFactory(): MarketingTranslateFactory
    {
        return MarketingTranslateFactory::new();
    }
}
