<?php

namespace Modules\Policy\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Policy\Database\factories\TermTranslateFactory;

class TermTranslate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['id', 'term_id', 'lang', 'name', 'desc', 'detail', 'deleted_at', 'created_at', 'updated_at'];
    protected $table = "term_translate";
    protected $primaryKey = "id";

    protected static function newFactory(): TermTranslateFactory
    {
        return TermTranslateFactory::new();
    }
}
