<?php

namespace Modules\Policy\database\seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PolicyDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Model::unguard();
        $lang = app()->getLocale();
        $now = DB::raw('NOW()');
        DB::statement("ALTER TABLE cookies AUTO_INCREMENT=1");
        DB::table('cookies')->truncate();
        DB::table('cookies')->insert([[
            'id' => 1,
            'code' => 'ad_storage',
            'sequence' => 1,
            'default' => 1,
            'status' => 1,
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 2,
            'code' => 'ad_user_data',
            'sequence' => 2,
            'default' => 0,
            'status' => 1,
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 3,
            'code' => 'ad_personalization',
            'sequence' => 3,
            'default' => 0,
            'status' => 1,
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 4,
            'code' => 'analytics_storage',
            'sequence' => 4,
            'default' => 0,
            'status' => 1,
            'created_at' => $now,
            'updated_at' => $now
        ]]);

        DB::statement("ALTER TABLE cookies_translate AUTO_INCREMENT=1");
        DB::table('cookies_translate')->truncate();
        DB::table('cookies_translate')->insert([[
            'id' => 1,
            'cookie_id' => 1,
            'lang' => $lang,
            'name' => 'คุกกี้ที่จำเป็นสำหรับการทำงานของเว็บไซต์',
            'desc' => '(Strictly Necessary Cookies)',
            'detail' => 'คุกกี้ประเภทนี้มีความสำคัญต่อการปฏิบัติการของเว็บไซต์',
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 2,
            'cookie_id' => 2,
            'lang' => $lang,
            'name' => 'คุกกี้ด้านประสิทธิภาพการทำงานของเว็บไซต์',
            'desc' => '(Performance Cookies)',
            'detail' => 'คุกกี้ประเภทนี้ใช้เพื่อรวบรวมข้อมูลทางสถิติเกี่ยวกับการใช้งานเว็บไซต์ของท่าน เพื่อวิเคราะห์ และช่วยให้เราทราบถึงพฤติกรรมการใช้งาน',
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 3,
            'cookie_id' => 3,
            'lang' => $lang,
            'name' => 'คุกกี้เพื่อปรับเนื้อหาเข้ากับกลุ่มเป้าหมาย',
            'desc' => '(Targeting Cookies)',
            'detail' => 'คุกกี้ประเภทนี้ใช้ในการบันทึก และจดจำคุณลักษณะต่างๆ ที่ท่านได้เลือกขณะเข้าชมเว็บไซต์ของเรา',
            'created_at' => $now,
            'updated_at' => $now
        ], [
            'id' => 4,
            'cookie_id' => 4,
            'lang' => $lang,
            'name' => 'คุกกี้เพื่อนำเสนอโฆษณาให้เข้ากับกลุ่มเป้าหมาย',
            'desc' => '(Advertising Cookies)',
            'detail' => 'คุกกี้ประเภทนี้ใช้เพื่อจดจำพฤติกรรมการอ่านเนื้อหาบนเว็บไซต์ของท่าน รวมถึงรายละเอียดของอุปกรณ์ที่ท่านใช้ เพื่อนำไปใช้วิเคราะห์การนำเสนอโฆษณาที่เหมาะสมกับท่านมากที่สุด',
            'created_at' => $now,
            'updated_at' => $now
        ]]);
    }
}
