
$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#log-datatable").length > 0) {
		$("#log-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/cookies/logs/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: [
				{ data: "DT_RowIndex", className: 'text-center' },
				{ data: "ip" },
				{ data: "agent" },
				{ data: "ad_storage" },
				{ data: "ad_user_data" },
				{ data: "ad_personalization" },
				{ data: "analytics_storage" },
				{ data: "created_at" },
			],
			language: $_LANG.datatable,
		});
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#log-datatable").length > 0) &&
		$("#log-datatable").DataTable().ajax.reload(null, bool);
}
