/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    ($_config.seo) && mwzGenerateMatadata(0);

    var lang = $("[name='mwz-lang'").val();
    var frm = $("#term_frm");
    var frm_data = new FormData($(frm)[0]);

    $.ajax({
        url: '/admin/policy/term/save',
        type: "POST",
        data: frm_data,
        contentType: false,
        processData: false,
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
        beforeSend: function (xhr) {
            // validate
            var rules = [], msg = [];
            $.each($_lang, function (i, lang) {
                $.each($_config.input, function (key, ele) {
                    rules[`${key}_${lang}`] = (key == "name") ? { required: ele.validate && ele.status, maxlength: 255 } : { required: ele.validate && ele.status };
                    msg[`${key}_${lang}`] = { required: $(frm).find(`[name="${key}_${lang}"]`).attr('placeholder') };
                });
            });

            mwz_validate($(frm), rules, msg);
            return frm_valid($(frm));
        }, success: function (resp) {
            mwz_noti("success", resp.msg, window.location.reload());
        }, error: function (xhr, status, thrown) {
            ajax_error(xhr, status, thrown);
        }
    });
};