import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-policy',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-policy',
			input: [
				__dirname + '/resources/assets/js/marketing.js',
				__dirname + '/resources/assets/sass/app.scss',
				__dirname + '/resources/assets/js/cookies.js',
				__dirname + '/resources/assets/js/policy.js',
				__dirname + '/resources/assets/js/accept.js',
				__dirname + '/resources/assets/js/term.js',
				__dirname + '/resources/assets/js/log.js'
			],
			refresh: true,
		}),
	],
});

//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];