<?php

namespace Modules\Setting\app\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class TestNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $subject, $setting;

    /**
     * Create a new message instance.
     */
    public function __construct($subject)
    {
        $this->subject = $subject;
        $this->setting = setting();
    }

    /**
     * Build the message.
     */
    public function build(): self
    {
        return $this->subject($this->subject)
            ->view('setting::smtp.mail', ['subject' => $this->subject, 'setting' => $this->setting]);
    }
}
