<?php

namespace Modules\Setting\app\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Setting\app\Models\Errors;
use Modules\Setting\app\Models\ErrorTranslate;

class ErrorAdminController extends AdminController
{
	protected  $config;

	/**
	 * Function : construct
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function __construct()
	{
		$this->middleware('auth:admin');
		self::$navbar[] =  ['name' => __("setting::error.title"), 'url' => route_has("admin.setting.error.index")];
	}

	/**
	 * Function : error page index
	 * Dev : Petch
	 * Update Date : 18 Apr 2024
	 * @return \Illuminate\Contracts\View\View setting::error.index
	 */
	public function index()
	{
		return view("setting::error.index", ['config' => $this->config, 'navbar' => self::$navbar]);
	}

	/**
	 * Function : error page datatable ajax
	 * Dev : Petch
	 * Update Date : 18 Apr 2024
	 * @param \Illuminate\Http\Request $request
	 * @return Yajra\DataTables\Facades\DataTables data table
	 */
	public function datatable_ajax(Request $request)
	{
		if ($request->ajax()) {
			//init datatable
			$dt_column = ['id', 'code', 'name', 'updated_at'];
			$dt_order = $request->get('order')[0]['column'];
			$dt_dir = $request->get('order')[0]['dir'];
			$dt_start = $request->get('start');
			$dt_length = $request->get('length');
			$dt_search = $request->get('search')['value'];
			$dt_filter = $request->get('filter');

			// create object
			$req = new Errors();

			// dt_search 
			if (!empty($dt_search))
				$req = $req->where('name', 'like', "%.{$dt_search}.%");

			// count all
			$dt_total = $req->count();

			// set query order & limit from datatable
			$result = $req->orderBy($dt_column[$dt_order], $dt_dir)
				->offset($dt_start)
				->limit($dt_length)
				->get();

			// prepare datatable for response
			$tables = datatables($result)
				->addIndexColumn()
				->setRowId('id')
				->setRowClass('data_row')
				->setTotalRecords($dt_total)
				->setFilteredRecords($dt_total)
				->setOffset($dt_start)
				->editColumn('updated_at', function ($record) {
					return str_replace(' ', '<br>', date('Y-m-d H:i:s', strtotime($record->updated_at)));
				})->editColumn('code', function ($record) {
					return $record->code ?? '';
				})->editColumn('name', function ($record) {
					return $record->local->title ?? '';
				})->addColumn('action', function ($record) {
					$btn = '<div class="button-list">';
					$btn .= self::btn_route("admin.setting.error.edit", $record->id);
					$btn .= '</div>';
					return $btn;
				})->escapeColumns([]);

			// response datatable json
			return $tables->make(true);
		}
	}

	/**
	 * Function : error page form
	 * Dev : Petch
	 * Update Date : 18 Apr 2024
	 * @param int $id
	 * @return \Illuminate\Contracts\View\View setting::error.form
	 */
	public function form($id = 0)
	{
		$data = Errors::find($id);
		if (!empty($data->langs)) {
			$data->langs = $data->langs->groupBy('lang')->map(function ($row) {
				return $row->first();
			});
		}
		array_push(self::$navbar, ['name' => __("navbar.form"), 'url' => null]);

		return view("setting::error.form", ['data' => $data, 'navbar' => self::$navbar]);
	}

	/**
	 * Function : error page save
	 * Dev : Petch
	 * Update Date : 18 Apr 2024
	 * @param \Illuminate\Http\Request $request
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function save(Request $request)
	{
		$rules =  $msg = [];
		foreach (languages() as $lang => $l) {
			$rules["title_{$lang}"] = 'required|max:255';
			$rules["desc_{$lang}"] = 'required';
			$msg["title_{$lang}.*"] = __('field.title_placeholder') . ' ' . ($l['name'] ?? '');
			$msg["desc_{$lang}.*"] = __('field.desc_placeholder') . ' ' . ($l['name'] ?? '');
		}
		//validate post data
		$valid = validator($request->all(),  $rules, $msg);
		if ($valid->fails()) {
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
		}
		$attr['status'] = $request->get("status");
		$set = Errors::updateOrcreate(['id' => $request->get('id')], $attr);
		if ($set->save()) {
			self::setLangs($request, $set);
			return self::response(['msg' => __('noti.success')]);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function :  set translate
	 * Dev : Petch
	 * Update Date : 18 Apr 2024
	 * @param \Illuminate\Http\Request $request
	 * @param int $id
	 */
	private function setLangs(Request $request, $row)
	{
		foreach (array_keys(languages()) as $lang) {
			$attr = [];
			foreach ($this->config['input'] as $key => $item) {
				$attr[$key] = mwz_setTextString($request->get("{$key}_{$lang}") ?? '', $item['type'] == 'texteditor');
			}
			$row->langs()->updateOrCreate(['lang' => $lang], $attr);
		}
	}
}
