<?php

namespace Modules\Setting\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\File;
use Modules\Mwz\app\Http\Controllers\AdminController;

class RobotAdminController extends AdminController
{
    private $path = "robots.txt";

    /**
     * Function : construct
     * Dev : Petch
     * Update Date : 18 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @param int $id
     */
    public function __construct()
    {
        self::$navbar = [
            ['name' => __('setting::robot.title'), 'url' => null],
            ['name' => __('setting::robot.name'), 'url' => route_has('admin.setting.robot.index')]
        ];
    }

    /**
     * Function : robot form
     * Dev : Petch
     * Update Date : 22 Apr 2024
     * @return \Illuminate\Contracts\View\View setting::robot.form
     */
    public function form()
    {
        $data = null;
        if (File::exists($this->path)) {
            $data = File::get($this->path);
        }
        return view('setting::robot.form', ['navbar' => self::$navbar, 'data' => $data]);
    }

    /**
     * Function : robot save
     * Dev : Petch
     * Update Date : 22 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function save(Request $request)
    {
        //validate post data
        $valid = validator($request->all(), ["detail" => 'required'], ["detail.*" => __('field.detail_placeholder')]);
        if ($valid->fails()) {
            return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
        }

        if (File::put($this->path, mwz_setTextString($request->get('detail')))) {
            return self::response(['msg' => __('noti.success')]);
        }
        return self::response(['msg' => __('noti.error')], Response::HTTP_MOVED_PERMANENTLY);
    }
}
