<?php

namespace Modules\Setting\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Setting\app\Emails\TestNotification;
use Modules\Setting\app\Models\SMTP;

class SMTPAdminController extends AdminController
{
    /**
     * Function : construct
     * Dev : Poom
     * Update Date : 19 Apr 2024
     */
    public function __construct()
    {
        self::$navbar = [
            ['name' => __('setting::smtp.title'), 'url' => null],
            ['name' => __('setting::smtp.name'), 'url' => route_has('admin.setting.smtp.index')]
        ];
    }

    /**
     * Function : notification form
     * Dev : Petch
     * Update Date : 19 Apr 2024
     * @return \Illuminate\Contracts\View\View setting::smtp.form
     */
    public function form()
    {
        $data = SMTP::find(1) ?? '';

        return view('setting::smtp.form', ['navbar' => self::$navbar, 'data' => $data]);
    }

    /**
     * Function : notification save
     * Dev : Petch
     * Update Date : 19 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function save(Request $request)
    {
        if (!mwz_roles(Route::currentRouteName())) {
            return self::response(['msg' => __('noti.not_permitted')], Response::HTTP_MOVED_PERMANENTLY);
        }
        $attr = ['line_token', 'email_host', 'email_port', 'email_username', 'email_password', 'email_encryption', 'email_address', 'email_name'];
        $rule = [];
        foreach ($attr as $key) {
            $rule[$key] = 'required|max:255';
        }

        $valid = validator($request->all(), $rule, [
            "line_token" => __("field.token_placeholder"),
            "email_host" => __("field.smtp.host_placeholder"),
            "email_port" => __("field.smtp.port_placeholder"),
            "email_username" => __("field.smtp.username_placeholder"),
            "email_password" => __("field.smtp.password_placeholder"),
            "email_encryption" => __("field.smtp.encryption_placeholder"),
            "email_address" => __("field.smtp.address_placeholder"),
            "email_name" => __("field.smtp.name_placeholder"),
        ]);

        if ($valid->fails()) {
            return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
        }
        $noti = SMTP::updateOrCreate(['id' => 1], [
            'line_token' => $request->get('line_token'),
            'email_host' => $request->get('email_host'),
            'email_port' => $request->get('email_port'),
            'email_username' => $request->get('email_username'),
            'email_password' => $request->get('email_password'),
            'email_encryption' => $request->get('email_encryption'),
            'email_address' => $request->get('email_address'),
            'email_name' => $request->get('email_name'),
            'line_status' => $request->get('line_status') ?? 0,
            'email_status' => $request->get('email_status') ?? 0
        ]);
        if ($noti->save())
            return self::response(['msg' => __('noti.success')]);

        return self::response(['msg' => __('noti.error')], Response::HTTP_MOVED_PERMANENTLY);
    }

    /**
     * Function : notification test line
     * Dev : Petch
     * Update Date : 19 Apr 2024
     * @return \Illuminate\Http\JsonResponse
     */
    public function line(Request $request)
    {
        $request->session()->forget('errors');
        if (!send_line_noti('ทดสอบการแจ้งเตือนจากระบบ')) {
            $request->session()->regenerate();
            $request->session()->put('errors', __('noti.error'));
        }

        return redirect()->back();
    }

    /**
     * Function : notification test email
     * Dev : Petch
     * Update Date : 19 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function email(Request $request)
    {
        $request->session()->forget('errors');
        try {
            config_mail();
            Mail::to(auth()->user()->email)->send(new TestNotification('Test Email Notification'));
        } catch (\Exception $e) {
            $request->session()->regenerate();
            $request->session()->put('errors', __('noti.error'));
        }

        return redirect()->back();
    }
}
