<?php

namespace Modules\Setting\app\Http\Controllers;

use App\View\Components\Upload\Image;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;
use Modules\Setting\app\Models\Setting;

class SettingAdminController extends AdminController
{
	/**
	 * Function :  set translate
	 * Dev : Poom
	 * Update Date : 18 Apr 2024
	 */
	public function __construct()
	{
		self::$navbar = [
			['name' => __('setting::setting.title'), 'url' => null],
			['name' => __('setting::setting.name'), 'url' => route_has('status.setting.index')]
		];
	}

	/**
	 * Function : form
	 * Dev : Poom
	 * Update Date : 18 Apr 2024
	 */
	public function form()
	{
		$meta = self::set_metadata('index', 'index', 1);
		$meta = array_merge($meta, SlugController::getMetadata('index', 'index', 1));

		$data = Setting::find(1) ?? '';
		if (!empty($data->langs)) {
			$data->langs = $data->langs->groupBy('lang')->map(function ($row) {
				return  $row->first();
			});
		}

		return view('setting::setting.form', [
			'navbar' => self::$navbar,
			'data' => $data,
			'meta' => $meta,
		]);
	}

	/**
	 * Function : save
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public function save(Request $request)
	{
		if (!mwz_roles(Route::currentRouteName()))
			return self::response(['msg' => __('noti.not_permitted')], Response::HTTP_FORBIDDEN);
		$rule = $msg = [];
		foreach (languages() as $lang => $l) {
			if (!empty($i['status']) && !empty($i['validate'])) {
				$rule["copy_right_{$lang}"] = 'max:255';
				$msg["copy_right_{$lang}.*"] = __("field.copy_right_placeholder") . ' ' . ($l['name'] ?? '');
			}
		}

		$valid = validator($request->all(), $rule, $msg);
		if ($valid->fails())
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], Response::HTTP_BAD_REQUEST);

		$attr = [
			'gtag' => $request->get('gtag'),
			'recapcha' => $request->get('recapcha'),
		];

		$images = [
			'logo_header' => 'logo-',
			'logo_footer' => 'footer-',
			'seo_image' => 'favicon-'
		];

		foreach ($images as $k => $prefix) {
			if (check_file_upload($request, $k, $k === 'seo_image' ? 'favicon' : 'image')) {
				$errorMsg = $k === 'seo_image' ? __('noti.mime_favicon') : __('noti.mime_image');
				return self::response(['msg' => ucfirst(str_replace('_', ' ', $k)) . " " . $errorMsg], Response::HTTP_BAD_REQUEST);
			} else {
				$attr[$k] = self::set_image_upload($request, $k, "public/setting", $prefix, $k === 'seo_image');
			}
		}
		$set = Setting::updateOrCreate(['id' => 1], $attr);
		if ($set->save()) {
			self::setLangs($request, $set);
			SlugController::createMetadata($request, 1);

			return self::response(['msg' => __('noti.success')]);
		}

		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function : set translate
	 * Dev : Petch
	 * Update Date : 19 Feb 2025
	 */
	private function setLangs(Request $request, $row)
	{
		foreach (array_keys(languages()) as $lang) {
			$attr = [];
			foreach (['copy_right'] as $v)
				$attr[$v] = !empty($request->get("{$v}_{$lang}")) ? $request->get("{$v}_{$lang}") : null;

			$row->langs()->updateOrCreate(['lang' => $lang], $attr);
		}
	}
}
