<?php

namespace Modules\Setting\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Setting\app\Models\Tags;

class TagAdminController extends AdminController
{
	private $action;
	/**
	 * Function : construct
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public function __construct()
	{
		$routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->action = $explode[3] ?? '';
		} else {
			$this->action = '';
		}

		self::$navbar = [
			['name' => __('setting::tag.title'), 'url' => null],
			['name' => __('setting::tag.name'), 'url' => route_has('admin.setting.tag.index')]
		];
	}

	/**
	 * Function : index
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function index()
	{
		return view('setting::tag.index', ['navbar' => self::$navbar]);
	}

	/**
	 * Function : data table ajax
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function datatable_ajax(Request $request)
	{
		if ($request->ajax()) {
			//init datatable
			$dt_column = array('id', 'type', 'updated_at');
			$dt_order = $request->get('order')[0]['column'];
			$dt_dir = $request->get('order')[0]['dir'];
			$dt_start = $request->get('start');
			$dt_length = $request->get('length');
			$dt_search = $request->get('search')['value'];

			// create brand object
			$req = new Tags();

			// add search query if have search from datable
			if (!empty($dt_search)) {
				$req = $req->where('type', 'like', "%" . $dt_search . "%")
					->orWhere('head', 'like', "%" . $dt_search . "%")
					->orWhere('updated_at', 'like', "%" . $dt_search . "%");
			}

			$dt_total = $req->count();
			// set query order & limit from datatable
			$resp = $req->orderBy($dt_column[$dt_order], $dt_dir)
				->offset($dt_start)->limit($dt_length)
				->get();

			// prepare datatable for response
			$tables = datatables($resp)
				->addIndexColumn()
				->setRowId('id')
				->setRowClass('tag_row')
				->setTotalRecords($dt_total)
				->setFilteredRecords($dt_total)
				->setOffset($dt_start)
				->editColumn('head', function ($record) {
					return limit($record->head, 60);
				})
				->editColumn('updated_at', function ($record) {
					return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->updated_at)));
				})
				->addColumn('action', function ($record) {
					$btn = '<div class="d-flex flex-nowrap gap-1">';
					$btn .= self::btn_status('admin.setting.tag.set_status', $record->id, 'setStatus', $record->status);
					$btn .= self::btn_route('admin.setting.tag.edit', $record->id);
					$btn .= self::btn_delete('admin.setting.tag.set_delete', $record->id, 'setDelete');
					$btn .= '</div>';

					return $btn;
				})
				->escapeColumns([]);

			// response datatable json
			return $tables->make(true);
		}
	}

	/**
	 * Function : form
	 * Dev : Petch
	 * Update Date : 21 Jan 2025
	 */
	public function form($id = 0)
	{
		self::$navbar[] = ['name' => __("action.{$this->action}"), 'url' => null];
		$data = [];
		if (!empty($id))
			$data = Tags::find($id);

		return view('setting::tag.form', [
			'data' => $data,
			'navbar' => self::$navbar,
			'action' => $this->action
		]);
	}

	/**
	 * Function : save
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function save(Request $request)
	{
		$valid = validator($request->all(), [
			'type' => 'required',
			'head' => 'required',
			'body' => 'required',
			'footer' => 'required',
		], [
			'type.required' => __('setting::tag.field.type_placeholder'),
			'head.required' => __('setting::tag.field.head_placeholder'),
			'body.required' => __('setting::tag.field.body_placeholder'),
			'footer.required' => __('setting::tag.field.footer_placeholder'),
		]);

		if ($valid->fails()) {
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
		}
		$set = Tags::updateOrcreate(
			['id' => $request->get('id')],
			[
				'type' => $request->get('type'),
				'head' => ($request->get('head')),
				'body' => ($request->get('body')),
				'footer' => ($request->get('footer')),
				'status' => $request->get('status') ?? 0
			]
		);
		if ($set->save()) {
			return self::response(['msg' => __('noti.success')]);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function : set status
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function set_status(Request $request)
	{
		$set = Tags::find($request->get('id'));
		$set->status = !$set->status;
		if ($set->save()) {
			return self::response(['msg' => __('noti.success')]);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}

	/**
	 * Function : set delete
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function set_delete(Request $request)
	{
		$set = Tags::find($request->get('id'));
		if ($set->delete()) {
			return self::response(['msg' => __('noti.success')]);
		}
		return self::response(['msg' => __('noti.error')], 404);
	}
}
