<?php

namespace Modules\Setting\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Setting\Database\factories\ErrorsFactory;

class Errors extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'code', 'status', 'created_at', 'updated_at'];
    protected $table = "errors";
    protected $primaryKey = "id";

    protected static function newFactory(): ErrorsFactory
    {
        return ErrorsFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }
    public function langs()
    {
        return $this->hasMany(ErrorTranslate::class, 'error_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(ErrorTranslate::class, 'error_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
}
