<?php

namespace Modules\Setting\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Setting\Database\factories\SMTPFactory;

class SMTP extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'line_token', 'line_status', 'email_host', 'email_port', 'email_username', 'email_password', 'email_encryption', 'email_address', 'email_name', 'email_status', 'created_at', 'updated_at'];
    protected $table = "setting_smtp";
    protected $primaryKey = "id";


    protected static function newFactory(): SMTPFactory
    {
        return SMTPFactory::new();
    }
}
