<?php

namespace Modules\Setting\database\seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Model::unguard();

        $now = DB::raw('NOW()');
        DB::statement("ALTER TABLE setting_language AUTO_INCREMENT=1");
        DB::table('setting_language')->truncate();
        DB::table('setting_language')->insert([
            [
                'id' => 1,
                'flag' => 'flag flag-th',
                'code' => 'th',
                'name' => 'ภาษาไทย',
                'sequence' => 1,
                'default' => 1,
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 2,
                'flag' => 'flag flag-en',
                'code' => 'en',
                'name' => 'English',
                'sequence' => 2,
                'default' => 0,
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ]
        ]);


        DB::statement("ALTER TABLE errors AUTO_INCREMENT=1");
        DB::table('errors')->truncate();

        DB::table('errors')->insert([
            [
                'id' => 1,
                'code' => '403',
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 2,
                'code' => '404',
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 3,
                'code' => '500',
                'status' => 1,
                'created_at' => $now,
                'updated_at' => $now
            ],
        ]);


        DB::statement("ALTER TABLE errors_translate AUTO_INCREMENT=1");
        DB::table('errors_translate')->truncate();
        DB::table('errors_translate')->insert([
            [
                'id' => 1,
                'error_id' => 1,
                'lang' => 'en',
                'title' => 'Forbidden ',
                'desc' => "403 Forbidden",
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 2,
                'error_id' => 2,
                'lang' => 'en',
                'title' => 'Not Found ',
                'desc' => "404 Not Found ",
                'created_at' => $now,
                'updated_at' => $now
            ], [
                'id' => 3,
                'error_id' => 3,
                'lang' => 'en',
                'title' => 'Server Error ',
                'desc' => "500 Internal Server Error",
                'created_at' => $now,
                'updated_at' => $now
            ],
        ]);
    }
}
