/**
* Function : Save
* Dev : Petch
* Update Date : 15 Feb 2025
*/
window.setSave = function () {
	event.preventDefault();
	const frm = $(`#setting_frm`);
	const frm_data = new FormData($(frm)[0]);

	$.ajax({
		url: "/admin/setting/save",
		type: "POST",
		contentType: false,
		data: frm_data,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			let rules = [], msg = [];

			$.each($_lang, function (i, lang) {
				rules[`copy_right_${lang}`] = { required: false, maxlength: 255 };
				msg[`copy_right_${lang}`] = { required: $(frm).find(`[name="copy_right_${lang}"]`).attr('placeholder') };
			});

			mwz_validate($(frm), rules, msg);

			if (!frm_valid($(frm))) {
				$(`#submit`).prop('disabled', false);
				return false;
			}

			return true;
		},
		success: function (resp) {
			mwz_noti("success", resp.msg || $_LANG.noti.save_success, window.location.reload());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};