
$(document).ready(function () {
	// init for tag
	initDatatable();
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	// =========================  tag =========================== //
	if ($("#tag-datatable").length > 0) {
		$("#tag-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/tag/datatable_ajax",
			},
			columns: [
				{ data: "id", orderable: true, className: 'text-center' },
				{ data: "type" },
				{ data: "updated_at" },
				{ data: "action", orderable: false, className: 'text-center' },
			],
			language: $_LANG.datatable,
		})
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	$("#tag-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();
	var frm = $("#tag_frm");
	var frm_data = new FormData($(frm)[0]);
	$.ajax({
		url: "/admin/tag/save",
		type: "POST",
		contentType: false,
		data: frm_data,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = {
				type: { required: true },
				head: { required: true },
				body: { required: true },
				footer: { required: true },
			};

			var msg = {
				type: { required: $(frm).find('[name="type"]').attr('placeholder') },
				head: { required: $(frm).find('[name="head"]').attr('placeholder') },
				body: { required: $(frm).find('[name="body"]').attr('placeholder') },
				footer: { required: $(frm).find('[name="footer"]').attr('placeholder') },
			};

			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) { mwz_noti("success", resp.msg, window.location.replace("/admin/tag")) },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
};
/**
* Function : Set Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/tag/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	})
}
/**
* Function : Delete data by id
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/tag/set_delete",
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) { mwz_noti("success", resp.msg, setReloadDataTable()); },
		error: function (xhr, status, thrown) { ajax_error(xhr, status, thrown); }
	});
}