<?php

namespace Modules\User\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Models\Permissions;
use Modules\User\app\Models\Activities;
use Modules\User\app\Models\Users;

class ActivitiesAdminController extends AdminController
{
	private $method, $config;
	/**
	 * Function : construct
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	public function __construct()
	{
		$exp = explode('.', Route::currentRouteName());
		$this->method = $exp[2];

		self::$navbar =  [
			['name' => __("user::{$this->method}.title"), 'url' => null],
			['name' => __("user::{$this->method}.name"), 'url' => route_has("admin.user.{$this->method}.index")]
		];

		$this->config = config("user.{$this->method}");
	}

	/**
	 * Function : index
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	public function index()
	{
		return view('user::activities.index', [
			'name' => $this->method,
			'navbar' => self::$navbar,
			'config' => $this->config
		]);
	}

	/**
	 * Function : datatable ajax
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	public function datatable_ajax(Request $request)
	{
		if ($request->ajax()) {
			//init datatable
			$dt_column = ['id'];
			foreach ($this->config['table']['header'] as $h)
				$dt_column[] = $h['column'];
			array_push($dt_column, 'created_at', 'action');

			$dt_order = $request->get('order')[0]['column'];
			$dt_dir = $request->get('order')[0]['dir'];
			$dt_start = $request->get('start');
			$dt_length = $request->get('length');
			$dt_search = $request->get('search')['value'];
			$dt_filter = $request->get('filter');

			$req = new Activities();

			if (!empty($dt_search))
				$req = $req->whereRelation('user', 'username', 'like', "%{$dt_search}%");

			if (!empty($dt_filter['user_id']))
				$req = $req->where('user_id', $dt_filter['user_id']);
			if (!empty($dt_filter['period']))
				$req = self::mwz_filter($req, $dt_filter['period'], 'created_at', $dt_filter['range']);

			$dt_total = $req->count();

			$resp  = $req->orderBy($dt_column[$dt_order], $dt_dir)
				->offset($dt_start)
				->limit($dt_length)
				->get();

			// prepare datatable for response
			$tables = datatables($resp)
				->addIndexColumn()
				->setRowId('id')
				->setRowClass('user_row')
				->setTotalRecords($dt_total)
				->setFilteredRecords($dt_total)
				->setOffset($dt_start)
				->editColumn('user_id', function ($record) {
					return $record->user->username ?? '';
				})->editColumn('menu', function ($record) {
					return self::get_name_menu($record->route);
				})->editColumn('act', function ($record) {
					$exp = explode('_', $record->action);
					if (count($exp) > 1)
						return implode(' ', array_map('ucfirst', $exp));

					return ucfirst($record->action ?? '');
				})->editColumn('created_at', function ($record) {
					return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->created_at)));
				})->addColumn('action', function ($record) {
					$btn = '<div class="button-list">';

					if (!empty($this->config['table']['btn']['view']))
						$btn .= self::btn_route("admin.user.{$this->method}.view", $record->id, 'btn-white', 'fe-menu');

					$btn .= '</div>';

					return $btn;
				})->escapeColumns([]);

			// response datatable json
			return $tables->make(true);
		}
	}

	/**
	 * Function : get name menu
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	private static function get_name_menu($route_name)
	{
		if (str_contains($route_name, 'login'))
			return 'ล็อกอิน';
		else if (str_contains($route_name, 'logout'))
			return 'ล็อกเอ้าท์';

		$exp = explode('.', $route_name);
		if ($exp[1] == 'mwz')
			return 'ระบบ';

		$exp[3] = 'index';
		$p = Permissions::where('name', implode('.', $exp))->first();

		return self::make_name($p->menu, $p->menu->name);
	}

	/**
	 * Function : make name
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	private static function make_name($menu, $name)
	{
		if (empty($menu->parent))
			return $name;

		return self::make_name($menu->parent, "{$menu->parent->name} &raquo; {$name}");
	}

	/**
	 * Function : form
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	public function form($id)
	{
		$data = Activities::find($id);

		return view('user::activities.form', [
			'name' => $this->method,
			'navbar' => self::$navbar,
			'data' => self::array_form($data),
		]);
	}

	/**
	 * Function : array form
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	private function array_form($param)
	{
		$data = [];

		foreach ($this->config['list'] as $k => $v) {
			if (!$v)
				continue;

			if ($k == 'user_id')
				$value = $param->user->username ?? '';
			else if ($k == 'route')
				$value = mwz_getTextString(self::get_name_menu($param->route));
			else
				$value = $param->{$k};

			$data[] = [
				'name' => $k,
				'value' => $value,
			];
		}

		return $data;
	}

	/**
	 * Function : get user list
	 * Dev : petch
	 * Update Date : 24 Jan 2025
	 */
	public function get_user_list(Request $request)
	{
		$filter = $request->get('parent');
		$users = new Users();

		if (!empty($filter['search']))
			$users = $users->where('username', 'like', "%{$filter['search']}%");

		$result = [];
		foreach ($users->get() as $u)
			$result[] = ['id' => $u->id, 'text' => $u->username, 'image' => $u->avatar ?? ''];

		return self::response(['results' => $result], 200);
	}
}
