<?php

namespace Modules\User\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\User\app\Models\Activities;

class ActivitiesController extends Controller
{
	/**
	 * Function : keep activites
	 * Dev : Petch
	 * Update Date : 24 Jan 2025
	 */
	public static function keep($request, $route = '')
	{
		$explode = explode('.', $route);
		if (count($explode) < 4 || $explode[3] == 'datatable_ajax')
			return;

		Activities::create([
			'user_id' => auth('admin')->user()->id,
			'route' => $route,
			'url' => $request->url(),
			'module' => $explode[1],
			'page' => $explode[2],
			'action' =>  $explode[3],
			'request' => json_encode($request->all()),
			'ip' => ip_address(),
			'agent' => $request->header('User-Agent')
		]);
	}
}
