<?php

namespace Modules\User\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\User\app\Events\UserLogin;
use Modules\User\app\Events\UserLogout;
use Modules\User\app\Models\Activities;
use Modules\User\app\Models\Users;

class LoginController extends AdminController
{
	/**
	 * Function : index
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function index(Request $request)
	{
		if (auth('admin')->check()) {
			return !empty($request->get('redirect')) ? redirect($request->get('redirect')) : redirect()->route('admin.homepage');
		}
		return view('user::login.form', ['redirect' => $request->get('redirect')]);
	}

	/**
	 * Function : setting login
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function set_login(Request $request)
	{
		$valid = validator(
			$request->all(),
			['username' => 'required', 'password' => 'required'],
			['username.*' => __('user::login.msg.username'), 'password.*' => __('user::login.msg.password')]
		);
		if ($valid->fails()) {
			return self::response(['msg' => $valid->errors()->first(), 'error' => $valid->errors()], 404);
		}
		$user = Users::where('username', $request->get('username'))->first();

		if (!empty($user)) {
			if ($user->status == 1 && !empty($user->role->status)) {
				if ($user->role->id != 1 && count($user->role->permissions) == 0)
					return self::response(['msg' => __('user::login.msg.error.group_role')], Response::HTTP_UNAUTHORIZED);
				$data = $request->validate(['username' => ['required'], 'password' => ['required']]);
				$data['status'] = 1;
				if (auth('admin')->attempt($data, $request->get('remember') ?? 0)) {
					// keep activities
					Activities::create([
						'user_id' => $user->id,
						'route' => Route::currentRouteName(),
						'module' => 'user',
						'page' => 'login',
						'action' => 'login',
						'ip' => ip_address(),
						'agent' => $request->header('User-Agent')
					]);
					try {
						$user->login_at = now();
						$user->save();

						UserLogin::dispatch($user);
					} catch (\Throwable $th) {
					}

					return self::response(['msg' => __('user::login.msg.success')]);
				}

				return self::response(['msg' => __('user::login.msg.error.password')], Response::HTTP_BAD_REQUEST);
			} else if ($user->status == 0)
				return self::response(['msg' => __('user::login.msg.error.status')], Response::HTTP_UNAUTHORIZED);
			else if (empty($user->role->status))
				return self::response(['msg' => __('user::login.msg.error.role')], Response::HTTP_UNAUTHORIZED);
		} else
			return self::response(['msg' => __('user::login.msg.error.username')], Response::HTTP_BAD_REQUEST);


		return self::response(['msg' => __('noti.error')], Response::HTTP_INTERNAL_SERVER_ERROR);
	}

	/**
	 * Function : log out
	 * Dev : Poom
	 * Update Date : 29 Apr 2024
	 */
	public function logout(Request $request)
	{
		try {
			UserLogout::dispatch(auth('admin')->user());
		} catch (\Throwable $th) {
		}
		// keep activities
		Activities::create([
			'user_id' => auth('admin')->user()->id,
			'route' => Route::currentRouteName(),
			'module' => 'user',
			'page' => 'logout',
			'action' => 'logout',
			'ip' => ip_address(),
			'agent' => $request->header('User-Agent')
		]);
		auth('admin')->logout();
		$request->session()->invalidate();
		$request->session()->regenerateToken();

		return redirect()->route('admin.login');
	}
}
