<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Users extends Authenticatable
{
	use HasFactory, SoftDeletes;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'role_id',
		'name',
		'username',
		'email',
		'password',
		'avatar',
		'lang',
		'login_at',
		'status',
		'remember_token',
	];
	protected $table = 'users';
	protected $primaryKey = 'id';

	protected $hidden = ['password', 'remember_token'];

	public function role()
	{
		return $this->hasOne(Roles::class, 'id', 'role_id');
	}
}
