<?php

namespace Modules\User\database\seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserDatabaseSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 */
	public function run(): void
	{
		Model::unguard();

		$now = DB::raw('NOW()');
		DB::statement("ALTER TABLE users AUTO_INCREMENT=1");
		DB::statement("ALTER TABLE user_roles AUTO_INCREMENT=1");

		DB::table('users')->truncate();
		DB::table('user_roles')->truncate();

		DB::table('users')->insert([[
			'id' => 1,
			'role_id' => '1',
			'name' => 'Superadmin',
			'username' => 'admin',
			'email' => 'admin@admin.com',
			'password' => Hash::make('admin'),
			'avatar' => '',
			'facebook_id' => '',
			'twitter_id' => '',
			'google_id' => '',
			'line_id' => '',
			'instagram_id' => '',
			'lang' => '',
			'login_at' => $now,
			'status' => 1,
			'remember_token' => '',
			'created_at' => $now,
			'updated_at' => $now
		]]);

		DB::table('user_roles')->insert([[
			'id' => 1,
			'name' => 'Superadmin Group',
			'sequence' => 1,
			'status' => 1,
			'created_at' => $now,
			'updated_at' => $now
		], [
			'id' => 2,
			'name' => 'General Admin',
			'sequence' => 1,
			'status' => 1,
			'created_at' => $now,
			'updated_at' => $now
		]]);
	}
}
