$(document).ready(function () {
    initDatatable();
    initcheckbox();
});
/**
 * Function : Init Datatable
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.initDatatable = function () {
    // =========================  role =========================== //
    if ($("#role-datatable").length > 0) {
        $("#role-datatable").DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            ajax: {
                url: "/admin/user/role/datatable_ajax",
                error: function (xhr, status, thrown) {
                    ajax_error(xhr, status, thrown);
                },
            },
            columns: [
                { data: "DT_RowIndex", className: "text-center" },
                { data: "name" },
                { data: "sort", orderable: false, className: "text-center" },
                { data: "updated_at" },
                { data: "action", orderable: false, className: "text-center" },
            ],
            language: $_LANG.datatable,
        });
        init_Table();
    }
};
/**
 * Function : Reload Datatable
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.setReloadDataTable = function (bool = false) {
    if ($("#role-datatable").length > 0)
        $("#role-datatable").DataTable().ajax.reload(null, bool);
};
/**
 * Function : Set Status
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.setStatus = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/user/role/set_status",
        type: "POST",
        data: { id: id },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (resp) {
            mwz_noti("success", resp.msg, setReloadDataTable());
        },
        error: function (xhr, status, thrown) {
            ajax_error(xhr, status, thrown);
        },
    });
};
/**
 * Function : Delete data by id
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.setDelete = function (id) {
    event.preventDefault();
    $.ajax({
        url: "/admin/user/role/set_delete",
        type: "POST",
        data: { id: id },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (resp) {
            mwz_noti("success", resp.msg, setReloadDataTable());
        },
        error: function (xhr, status, thrown) {
            ajax_error(xhr, status, thrown);
        },
    });
};
/**
 * Function : Sort Item
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.setSort = function (id, move) {
    event.preventDefault();
    $.ajax({
        url: `/admin/user/role/set_sort`,
        type: "POST",
        data: { id: id, move: move },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (resp) {
            setReloadDataTable();
        },
        error: function (xhr, status, thrown) {
            ajax_error(xhr, status, thrown);
        },
    });
};
/**
 * Function : Save
 * Dev : Poom
 * Update Date : 26 Apr 2024
 */
window.setSave = function () {
    event.preventDefault();
    var frm = $("#role_frm");
    var frm_data = new FormData($(frm)[0]);
    $.ajax({
        url: "/admin/user/role/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        beforeSend: function (xhr) {
            // validate
            var rules = {
                name: { required: true, maxlength: 255 },
                permissions: { required: true },
            };

            var msg = $_LANG.validate.message;

            mwz_validate($(frm), rules, msg);
            return frm_valid($(frm));
        },
        success: function (resp) {
            mwz_noti(
                "success",
                resp.msg,
                window.location.replace("/admin/user/role")
            );
        },
        error: function (xhr, status, thrown) {
            ajax_error(xhr, status, thrown);
        },
    });
};
/**
 * Function : init checkbox
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
window.initcheckbox = function () {
    let level = "",
        chk = false;
    $('input[name="permissions[]"]')
        .toArray()
        .forEach((input) => {
            if ($_checked.includes(parseInt($(input).val()))) {
                $(input).prop("checked", true);

                if (
                    input.getAttribute("onclick") &&
                    input.getAttribute("onclick").length > 0
                ) {
                    level = input.getAttribute("onclick").match(/'([^']+)'/)[1];
                    chk = $(
                        `#${level} input[name='permissions[]'].form-check-input`
                    )
                        .toArray()
                        .every((input) => $(input).is(":checked"));
                    $(`#${level.split("-")[2]}`).prop("checked", chk);
                    check_level_above(level);
                }
            }
        });
    
    // Initialize OilPrice ABC checkboxes
    if (typeof $_oilprice_abc_checked !== 'undefined') {
        $_oilprice_abc_checked.forEach(function(value) {
            $('input[name="oilprice_abc[]"][value="' + value + '"]').prop('checked', true);
        });
    }
};
/**
 * Function : check all
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
window.set_all = (ele, name) => {
    $(`#${name} :checkbox`).prop("checked", $(ele).is(":checked"));
    if (name != "permission") check_level_above(name);
};

/**
 * Function : check status
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
window.check_status = (ele, name) => {
    const status = $(ele).attr("data-status");
    const pid = $(ele).attr("data-pid");
    const id = $(ele).attr("id");
    const is_chk = $(ele).is(":checked");
    const inputName = $(ele).attr("name");

    if (status !== "view" && is_chk)
        $(`input[data-pid='${pid}'][data-status='view']`).prop("checked", true);
    else if (status == "view" && !is_chk) {
        $(`input[data-pid='${pid}']`).prop("checked", false);
    }

    // When oilprice ABC is checked, ensure both edit and view are checked
    if (inputName === "oilprice_abc[]" && is_chk) {
        $(`input[data-pid='${pid}'][data-status='view']`).prop("checked", true);
        $(`input[data-pid='${pid}'][data-status='edit']`).prop("checked", true);
    }

    $(`input[data-children='${id}']`).prop("checked", is_chk);
    const chk = !is_chk
        ? false
        : $(`#${name} input[name='permissions[]'].form-check-input`)
              .toArray()
              .every((input) => $(input).is(":checked"));

    $(`#${name.split("-")[2]}`).prop("checked", chk);

    check_level_above(name);
};

/**
 * Function : check oilprice abc
 * Dev : Petch
 * Update Date : 06 Oct 2025
 */
window.check_oilprice_abc = (ele, name) => {
    const pid = $(ele).attr("data-pid");
    const is_chk = $(ele).is(":checked");

    if (is_chk) {
        // ensure edit and view are checked when any ABC is checked
        $(`input[data-pid='${pid}'][data-status='view']`).prop("checked", true);
        $(`input[data-pid='${pid}'][data-status='edit']`).prop("checked", true);
    }

    check_level_above(name);
};

/**
 * Function : check level
 * Dev : Petch
 * Update Date : 21 Jan 2025
 */
window.check_level_above = (name) => {
    const s_name = name.split("-");
    const sub_s_name = s_name[2].split("_");

    for (let i = parseInt(s_name[1]); i > 0; i--)
        $(`#${sub_s_name.slice(0, i).join("_")}`).prop(
            "checked",
            $(
                `#${s_name[0]}-${i}-${sub_s_name
                    .slice(0, i)
                    .join("_")} input[name='permissions[]'].form-check-input`
            )
                .toArray()
                .every((input) => $(input).is(":checked"))
        );

    $("#all_roles").prop(
        "checked",
        $(`#permission input[name='permissions[]'].form-check-input`)
            .toArray()
            .every((input) => $(input).is(":checked"))
    );
};
