<div class="row">
    @if (!empty($config['table']['filter']))
        @foreach ($config['table']['filter'] as $k_f => $f)
            <div class="col-lg-3 col-md-6 my-1">
                @if ($f['type'] == 'selection_date')
                    <x-select2.selection class="frm-filter" id="{{ $k_f }}" name="filter[{{ $k_f }}]" label='{{ __("filter.{$k_f}") }}'>
                        @slot('option')
                            @php
                                $opts = [
                                    '7' => __('filter.custom'),
                                    '00' => __('filter.all'),
                                    '1' => __('filter.today'),
                                    '2' => __('filter.yesterday'),
                                    '3' => __('filter.last_7_days'),
                                    '4' => __('filter.last_30_days'),
                                    '5' => __('filter.this_month'),
                                    '6' => __('filter.last_month'),
                                ];
                            @endphp
                            @foreach ($opts as $k => $v)
                                <option value="{{ $k }}">{{ $v }}</option>
                            @endforeach
                        @endslot
                    </x-select2.selection>
                    <div class="input-group mt-3 date-range" style="display: none;">
                        <span class="input-group-text"><i class="mdi mdi-calendar-month"></i></span>
                        <input class="form-control range-filter frm-filter" id="range" name="filter[range]" type="text" placeholder="{{ __('filter.range') }}">
                    </div>
                @elseif ($f['type'] == 'select')
                    <x-select2.select class="frm-filter" id="{{ $k_f }}" name="filter[{{ $k_f }}]" label='{{ __("filter.{$k_f}") }}' url="{{ route($f['url']) }}" />
                @endif
            </div>
        @endforeach
    @endif
</div>
