@extends('login.app')

@section('styles')
    {{ module_vite('build-user', 'resources/assets/sass/app.scss') }}
@endsection

@section('content')
    <?php $setting = setting(); ?>
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-4">
            <div class="login-logo">
                <img src="{{ check_file($setting->logo_header ?? '', asset('assets/images/logo-alt.png')) }}">
            </div>
            <div class="card card-body shadow-none">
                <div class="text-center">
                    <h4 class="text-uppercase my-2">{{ __('user::login.title') }}</h4>
                </div>
                <form id="login_frm" onsubmit="set_login(); return false;">
                    @csrf
                    <div class="mb-2">
                        <label class="form-label" for="username">{{ __('user::login.frm.username') }}</label>
                        <input class="form-control" id="username" name="username" type="text" autocomplete="new-username" placeholder="{{ __('user::login.frm.username_placeholder') }}">
                    </div>
                    <div class="mb-2">
                        <label class="form-label" for="password">{{ __('user::login.frm.password') }}</label>
                        <div class="input-group input-group-merge">
                            <input class="form-control" id="password" name="password" type="password" placeholder="{{ __('user::login.frm.password_placeholder') }}" autocomplete="new-password">
                            <div class="input-group-text" data-password="false"> <span class="password-eye"></span></div>
                        </div>
                    </div>
                    <div class="mb-3 form-check">
                        <input class="form-check-input" id="remember" name="remember" type="checkbox" value="1">
                        <label class="form-check-label" for="remember">{{ __('user::login.frm.remember') }}</label>
                    </div>
                    <div class="d-grid text-center">
                        <button class="btn btn-primary" type="submit">{{ __('user::login.frm.submit') }}</button>
                    </div>
                </form>
            </div>
            <div class="d-grid text-center">
                {{ $setting->local->copy_right ?? '' }}
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <!-- if production -->
    {{ module_vite('build-user', 'resources/assets/js/login.js') }}
@endsection
