@extends('form.app')

@section('styles')
    {{ module_vite('build-user', 'resources/assets/sass/app.scss') }}
@endsection

@section('content')
    @includeIf('user::role.form.navbar')

    <form class="row" id="role_frm" method="POST" onsubmit="setSave(); return false;" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-md">
            <div class="card">
                <div class="card-body">
                    {{-- name --}}
                    @includeIf('user::role.form.name')
                    @includeIf('user::role.form.permission')
                </div>
            </div>
        </div>

        <div class="col-md-3 {{ !empty($data->id) && $data->id == 1 ? 'd-none' : '' }}">
            {{-- status --}}
            @includeIf('user::role.form.status')
        </div>
    </form>
@endsection

@section('scripts')
    <script>
        const $_checked = $.parseJSON('<?= json_encode($checked) ?>');
        const $_oilprice_abc_checked = $.parseJSON('<?= json_encode($oilprice_abc_checked ?? []) ?>');
    </script>
    {{ module_vite('build-user', 'resources/assets/js/role.js') }}
@endsection
